import logging, re
from enum import Enum

# Enumeration classes are redundant with gRPC classes, but gRPC does not provide a programmatical method to retrieve
# the values it expects from strings containing the desired value symbol or its integer value, so a kind of mapping is
# required. Besides, ORM Models expect Enum classes in EnumeratedFields; we create specific and conveniently defined
# Enum classes to serve both purposes.

LOGGER = logging.getLogger(__name__)

def grpc_to_enum(grpc_enum_class, orm_enum_class : Enum, grpc_enum_value):
    #LOGGER.info('grpc_enum_class={:s}'.format(str(grpc_enum_class)))
    #LOGGER.info('orm_enum_class={:s}'.format(str(orm_enum_class)))
    #LOGGER.info('grpc_enum_value={:s}'.format(str(grpc_enum_value)))

    grpc_enum_name = grpc_enum_class.Name(grpc_enum_value)
    #LOGGER.info('grpc_enum_name={:s}'.format(str(grpc_enum_name)))

    grpc_enum_prefix = orm_enum_class.__name__.upper()
    #LOGGER.info('grpc_enum_prefix={:s}'.format(str(grpc_enum_prefix)))
    grpc_enum_prefix = re.sub(r'^ORM_(.+)$', r'\1', grpc_enum_prefix)
    #LOGGER.info('grpc_enum_prefix={:s}'.format(str(grpc_enum_prefix)))
    grpc_enum_prefix = re.sub(r'^(.+)ENUM$', r'\1', grpc_enum_prefix)
    #LOGGER.info('grpc_enum_prefix={:s}'.format(str(grpc_enum_prefix)))
    grpc_enum_prefix = grpc_enum_prefix + '_'

    orm_enum_name = grpc_enum_name.replace(grpc_enum_prefix, '')
    #LOGGER.info('orm_enum_name={:s}'.format(str(orm_enum_name)))

    orm_enum_value = orm_enum_class._member_map_.get(orm_enum_name) # pylint: disable=protected-access
    #LOGGER.info('orm_enum_value={:s}'.format(str(orm_enum_value)))

    return orm_enum_value
