import logging
from common.orm.fields.ForeignKeyField import ForeignKeyField
from common.orm.fields.PrimaryKeyField import PrimaryKeyField
from common.orm.model.Model import Model
from .DeviceModel import DeviceModel
from .LinkModel import LinkModel
from .TopologyModel import TopologyModel

LOGGER = logging.getLogger(__name__)

class TopologyDeviceModel(Model):
    pk = PrimaryKeyField()
    topology_fk = ForeignKeyField(TopologyModel)
    device_fk = ForeignKeyField(DeviceModel)

class TopologyLinkModel(Model):
    topology_fk = ForeignKeyField(TopologyModel)
    link_fk = ForeignKeyField(LinkModel)
