import logging
from typing import Dict
from common.orm.fields.PrimaryKeyField import PrimaryKeyField
from common.orm.fields.StringField import StringField
from common.orm.model.Model import Model

LOGGER = logging.getLogger(__name__)

class LinkModel(Model):
    pk = PrimaryKeyField()
    link_uuid = StringField(required=True, allow_empty=False)

    def dump_id(self) -> Dict:
        return {'link_uuid': {'uuid': self.link_uuid}}

    #def dump_topology_ids(self) -> List[Dict]:
    #    db_topology_pks = self.references(TopologyModel)
    #    return [TopologyModel(self.database, pk).dump_id() for pk in db_topology_pks]

    def dump(self) -> Dict:
        return {
            'link_id': self.dump_id(),
            #'link_endpoint_ids': self.dump_endpoints(),
        }
