from .openconfig_interfaces import openconfig_interfaces
from pyangbind.lib.serialise import pybindIETFXMLEncoder

def set_vlan(OptionalParams):                                   #[L2/L3] Sets a VLANID and a VENDOR that will be requested for executing the following methods
    verify = str(OptionalParams)                                    #Verify transforms the received parameters into a string format for later making verifications and modifications
    
    #If the Vendor parameter is defined [OPTIONAL-PARAMETER]
    if verify.find('vendor')>0:
        Vendor = OptionalParams['vendor']  

    #If the VlanID parameter is defined [OPTIONAL-PARAMETER]
    if verify.find('vlan_id')>0:
        VlanID = OptionalParams['vlan_id'] 
        if VlanID == 0 and "ADVA" in Vendor: vlan = '  <untagged-allowed xmlns="http://www.advaoptical.com/cim/adva-dnos-oc-interfaces">true</untagged-allowed></config> \n          </config>\n        </subinterface>'
        elif VlanID != 0:                    vlan = '</config>\n          <vlan xmlns="http://openconfig.net/yang/vlan"> \n\t    <match> \n\t      <single-tagged> \n \t\t<config>\n \t\t  <vlan-id>'+str(VlanID)+'</vlan-id> \n \t\t</config> \n \t      </single-tagged> \n \t    </match> \n \t  </vlan> \n         </subinterface>'
        else:                                vlan = '</subinterface>\n          </config>'
    else:                                    vlan = '</subinterface>\n          </config>'   
    return vlan

def set_ip(OptionalParams):                                     #[L3]    Sets a IPAddress that will be requested for executing the following L3VPN methods
    verify = str(OptionalParams)                                 # Verify transforms the received parameters into a string format for later making verifications and modifications
    
    #If the Address_ip parameter is defined [OPTIONAL-PARAMETER]
    if verify.find('address_ip')>0:
        IP      = OptionalParams['address_ip']  
        Prefix  = OptionalParams['address_prefix']
        address = '  <ipv4 xmlns="http://openconfig.net/yang/interfaces/ip"> \n\t    <addresses> \n\t      <address> \n \t\t<ip>'+IP+'</ip> \n \t\t<config>\n \t\t  <ip>'+IP+'</ip> \n \t\t  <prefix-length>'+str(Prefix)+'</prefix-length> \n \t\t</config> \n \t      </address> \n \t    </addresses> \n \t  </ipv4>  \n \t</subinterface>'
    else:
        address ='</subinterface>'
    return address

def create_If_SubIf(parameters):                                # [L2/L3] Creates a Interface with a Subinterface as described in /interface[{:s}]/subinterface[{:d}]
    Interface_name     = parameters['name']
    DEL                = parameters['DEL']                      # If the parameters DEL is set to "TRUE" that will mean that is for making a DELETE, ELSE is for creating
    verify             = str(parameters)                        # Verify transforms the received parameters into a string format for later making verifications and modifications

    #Create an instance of the YANG model
    InterfaceInstance = openconfig_interfaces()

    if DEL==True:                                               #DELETE OPERATION
        # Access the entry container
        InterfaceInstance_set = InterfaceInstance.interfaces.interface.add(name = Interface_name)
        
        # Dump the entire instance as RFC 7950 XML
        InterfaceInstance_set = pybindIETFXMLEncoder.serialise(InterfaceInstance)

        #Replace for setting the "Delete" Operation
        InterfaceInstance_set = InterfaceInstance_set.replace('<interface>','<interface xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0" nc:operation="delete">')

        #Generic Replaces
        InterfaceInstance_set = InterfaceInstance_set.replace('<openconfig-interfaces xmlns="http://openconfig.net/yang/interfaces">',"")
        InterfaceInstance_set = InterfaceInstance_set.replace('<interfaces>','<interfaces xmlns="http://openconfig.net/yang/interfaces">')
        InterfaceInstance_set = InterfaceInstance_set.replace('</openconfig-interfaces>','')

    else:                                                       #MERGE OPERATION
        Interface_type     = parameters['type']
        SubInterface_Index = parameters["index"]

        #Access the entry container
        InterfaceInstance_set = InterfaceInstance.interfaces.interface.add(name = Interface_name)
        InterfaceInstance_set.config.name = Interface_name
        InterfaceInstance_set.config.enabled = True

        #SubIntefaces-Config
        SubInterfaceInstance              = InterfaceInstance_set.subinterfaces.subinterface.add(index = SubInterface_Index)
        SubInterfaceInstance.config.index = SubInterface_Index

        #If the description parameter is defined [OPTIONAL-PARAMETER]
        if verify.find('description')>0:
            Description = parameters['description']   
            if  len(Description) != 0: SubInterfaceInstance.config.description = Description   #If description parameter has a value

        #If the MTU parameter is defined [OPTIONAL-PARAMETER]
        if verify.find('mtu')>0:
            MTU = parameters['mtu']    
            if  MTU != 0: InterfaceInstance_set.config.mtu = MTU                       #If MTU parameter has a value

        #Dump the entire instance as RFC 750 XML
        InterfaceInstance_set = pybindIETFXMLEncoder.serialise(InterfaceInstance)

        #Replaces for adding the Interface Type
        InterfaceInstance_set = InterfaceInstance_set.replace('</config>\n      <subinterfaces>','  <type xmlns:ianaift="urn:ietf:params:xml:ns:yang:iana-if-type">ianaift:'+Interface_type+'</type>\n      </config>\n      <subinterfaces>')
        vlan = set_vlan(parameters)
        InterfaceInstance_set = InterfaceInstance_set.replace('</config>\n        </subinterface>',vlan)
        
        if "l3ipvlan" in Interface_type: 
            ip = set_ip(parameters)
            InterfaceInstance_set = InterfaceInstance_set.replace('</subinterface>',ip)

        #Generic Replaces
        InterfaceInstance_set = InterfaceInstance_set.replace('<openconfig-interfaces xmlns="http://openconfig.net/yang/interfaces">',"")
        InterfaceInstance_set = InterfaceInstance_set.replace('<interfaces>','<interfaces xmlns="http://openconfig.net/yang/interfaces">')
        InterfaceInstance_set = InterfaceInstance_set.replace('</openconfig-interfaces>','')

    return (InterfaceInstance_set) 
