# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from flask import render_template, Blueprint, flash, session, redirect, url_for
from device.client.DeviceClient import DeviceClient
from context.client.ContextClient import ContextClient
from webui.Config import (CONTEXT_SERVICE_ADDRESS, CONTEXT_SERVICE_PORT)
from webui.proto.context_pb2 import (Empty, LinkList)

link = Blueprint('link', __name__, url_prefix='/link')
context_client: ContextClient = ContextClient(CONTEXT_SERVICE_ADDRESS, CONTEXT_SERVICE_PORT)

@link.get('/')
def home():
    context_uuid = session.get('context_uuid', '-')
    if context_uuid == "-":
        flash("Please select a context!", "warning")
        return redirect(url_for("main.home"))
    request: Empty = Empty()
    context_client.connect()
    response: LinkList = context_client.ListLinks(request)
    context_client.close()
    return render_template(
        "link/home.html",
        links=response.links,
    )