# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

import pcep.service.tools.Grpc_TestClient.grpcService_pb2 as grpcService__pb2
#import grpcService_pb2 as grpcService__pb2


class pceServiceStub(object):
    """Defining a Service, a Service can have multiple RPC operations"""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.update = channel.unary_unary(
                '/src.main.proto.pceService/update',
                request_serializer=grpcService__pb2.commandRequest.SerializeToString,
                response_deserializer=grpcService__pb2.commandResponse.FromString,
                )
        self.getLSPdb = channel.unary_unary(
                '/src.main.proto.pceService/getLSPdb',
                request_serializer=grpcService__pb2.LSPdb_Request.SerializeToString,
                response_deserializer=grpcService__pb2.LSPdb_Response.FromString,
                )
        self.getSessionsInfo = channel.unary_unary(
                '/src.main.proto.pceService/getSessionsInfo',
                request_serializer=grpcService__pb2.Session_Request.SerializeToString,
                response_deserializer=grpcService__pb2.Session_Response.FromString,
                )

class pceServiceServicer(object):
    """Defining a Service, a Service can have multiple RPC operations"""

    def update(self, request, context):
        """RPC method for command execution"""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getLSPdb(self, request, context):
        """RPC method for retrieving LSP database"""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def getSessionsInfo(self, request, context):
        """RPC method for retrieving LSP database"""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

def add_pceServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'update': grpc.unary_unary_rpc_method_handler(
                    servicer.update,
                    request_deserializer=grpcService__pb2.commandRequest.FromString,
                    response_serializer=grpcService__pb2.commandResponse.SerializeToString,
            ),
            'getLSPdb': grpc.unary_unary_rpc_method_handler(
                    servicer.getLSPdb,
                    request_deserializer=grpcService__pb2.LSPdb_Request.FromString,
                    response_serializer=grpcService__pb2.LSPdb_Response.SerializeToString,
            ),
            'getSessionsInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.getSessionsInfo,
                    request_deserializer=grpcService__pb2.Session_Request.FromString,
                    response_serializer=grpcService__pb2.Session_Response.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'src.main.proto.pceService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))

 # This class is part of an EXPERIMENTAL API.
class pceService(object):
    """Defining a Service, a Service can have multiple RPC operations"""

    @staticmethod
    def update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/src.main.proto.pceService/update',
            grpcService__pb2.commandRequest.SerializeToString,
            grpcService__pb2.commandResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getLSPdb(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/src.main.proto.pceService/getLSPdb',
            grpcService__pb2.LSPdb_Request.SerializeToString,
            grpcService__pb2.LSPdb_Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def getSessionsInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/src.main.proto.pceService/getSessionsInfo',
            grpcService__pb2.Session_Request.SerializeToString,
            grpcService__pb2.Session_Response.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
