# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc, logging
from pcep.service.tools.GrpcServer import GrpcServer
from common.method_wrappers.Decorator import MetricsPool, safe_and_metered_rpc_method
from common.proto.pcep_pb2 import (RequestRq, RequestRp, PceIpRq, PceIpRp)
from common.proto.pcep_pb2_grpc import PcepServiceServicer

LOGGER = logging.getLogger(__name__)

METRICS_POOL = MetricsPool('Service', 'RPC')

class PcepServiceServicerImpl(PcepServiceServicer):
    def __init__(self, pcepServer : GrpcServer) -> None:
        LOGGER.debug('Creating Servicer...')
        self.pcepServer=pcepServer
        LOGGER.debug('Servicer Created')
   
    @safe_and_metered_rpc_method(METRICS_POOL, LOGGER)
    def configuratePCE(self, request : PceIpRq, context : grpc.ServicerContext) -> PceIpRp:
        LOGGER.debug("(ConfiguratePCE) Create pce instance %s",request)
        # configurateIP=self.pcepServer.connectToJavaPcep(request.address)
        #return PceIpRp(addressRp=configurateIP)
        return PceIpRp(addressRp="127.0.0.1")
    
    @safe_and_metered_rpc_method(METRICS_POOL, LOGGER)
    def sendRequest(self, request : RequestRq, context : grpc.ServicerContext) -> RequestRp:
        LOGGER.debug("(Send Request) Send:  %s",request.command)
        message=self.pcepServer.requestToJavaPcep(request.command)
        return RequestRp(commandRp=message)
