# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import component_link
class component_links(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/component-links. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A set of component links.
  """
  __slots__ = ('_path_helper', '_extmethods', '__component_link',)

  _yang_name = 'component-links'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__component_link = YANGDynClass(base=YANGListType("sequence",component_link.component_link, yang_name="component-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None, choice=('bundle-stack-level', 'component')), is_container='list', yang_name="component-link", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'component-links']

  def _get_component_link(self):
    """
    Getter method for component_link, mapped from YANG variable /networks/network/link/te/component_links/component_link (list)

    YANG Description: Specifies a component interface that is
sufficient to unambiguously identify the
appropriate resources.
    """
    return self.__component_link
      
  def _set_component_link(self, v, load=False):
    """
    Setter method for component_link, mapped from YANG variable /networks/network/link/te/component_links/component_link (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_component_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_component_link() directly.

    YANG Description: Specifies a component interface that is
sufficient to unambiguously identify the
appropriate resources.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sequence",component_link.component_link, yang_name="component-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None, choice=('bundle-stack-level', 'component')), is_container='list', yang_name="component-link", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """component_link must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sequence",component_link.component_link, yang_name="component-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None, choice=('bundle-stack-level', 'component')), is_container='list', yang_name="component-link", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__component_link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_component_link(self):
    self.__component_link = YANGDynClass(base=YANGListType("sequence",component_link.component_link, yang_name="component-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sequence', extensions=None, choice=('bundle-stack-level', 'component')), is_container='list', yang_name="component-link", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

  component_link = __builtin__.property(_get_component_link, _set_component_link)

  __choices__ = {'bundle-stack-level': {'component': ['component_link']}}
  _pyangbind_elements = OrderedDict([('component_link', component_link), ])


