# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import Dict
from sqlalchemy import Column, Float, ForeignKey, String
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from ._Base import _Base

class TopologyModel(_Base):
    __tablename__ = 'topology'
    context_uuid = Column(UUID(as_uuid=False), ForeignKey('context.context_uuid'), primary_key=True)
    topology_uuid = Column(UUID(as_uuid=False), primary_key=True, unique=True)
    topology_name = Column(String(), nullable=False)
    created_at   = Column(Float)

    # Relationships
    context         = relationship('ContextModel', back_populates='topology')
    topology_device = relationship('TopologyDeviceModel', back_populates='topologies')
    #topology_link   = relationship('TopologyLinkModel', back_populates='topology')
    endpoints       = relationship('EndPointModel', back_populates='topology')

    def dump_id(self) -> Dict:
        return {
            'context_id': self.context.dump_id(),
            'topology_uuid': {'uuid': self.topology_uuid},
        }

    def dump(self) -> Dict:
        return {
            'topology_id': self.dump_id(),
            'name'       : self.topology_name,
            'device_ids' : [{'device_uuid': {'uuid': td.device_uuid}} for td in self.topology_device],
            #'link_ids'   : [{'link_uuid'  : {'uuid': td.link_uuid  }} for td in self.topology_link  ],
        }
