/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix mappingBitMatrix;
    private final BitMatrix readMappingMatrix;
    private final Version version;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n = bitMatrix.getHeight();
        if (n < 10 || n > 144 || (n & 1) != 0) {
            throw FormatException.getFormatInstance();
        }
        this.version = this.readVersion(bitMatrix);
        this.mappingBitMatrix = this.extractDataRegion(bitMatrix);
        this.readMappingMatrix = new BitMatrix(this.mappingBitMatrix.getHeight());
    }

    Version readVersion(BitMatrix bitMatrix) throws FormatException {
        int n;
        if (this.version != null) {
            return this.version;
        }
        int n2 = n = bitMatrix.getHeight();
        return Version.getVersionForDimensions(n, n2);
    }

    byte[] readCodewords() throws FormatException {
        int n;
        byte[] byArray = new byte[this.version.getTotalCodewords()];
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        int n5 = n = this.mappingBitMatrix.getHeight();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            if (n3 == n && n4 == 0 && !bl) {
                byArray[n2++] = (byte)this.readCorner1(n, n5);
                n3 -= 2;
                n4 += 2;
                bl = true;
                continue;
            }
            if (n3 == n - 2 && n4 == 0 && (n5 & 3) != 0 && !bl2) {
                byArray[n2++] = (byte)this.readCorner2(n, n5);
                n3 -= 2;
                n4 += 2;
                bl2 = true;
                continue;
            }
            if (n3 == n + 4 && n4 == 2 && (n5 & 7) == 0 && !bl3) {
                byArray[n2++] = (byte)this.readCorner3(n, n5);
                n3 -= 2;
                n4 += 2;
                bl3 = true;
                continue;
            }
            if (n3 == n - 2 && n4 == 0 && (n5 & 7) == 4 && !bl4) {
                byArray[n2++] = (byte)this.readCorner4(n, n5);
                n3 -= 2;
                n4 += 2;
                bl4 = true;
                continue;
            }
            do {
                if (n3 >= n || n4 < 0 || this.readMappingMatrix.get(n4, n3)) continue;
                byArray[n2++] = (byte)this.readUtah(n3, n4, n, n5);
            } while ((n3 -= 2) >= 0 && (n4 += 2) < n5);
            ++n3;
            n4 += 3;
            do {
                if (n3 < 0 || n4 >= n5 || this.readMappingMatrix.get(n4, n3)) continue;
                byArray[n2++] = (byte)this.readUtah(n3, n4, n, n5);
            } while ((n3 += 2) < n && (n4 -= 2) >= 0);
            n3 += 3;
            ++n4;
        } while (n3 < n || n4 < n5);
        if (n2 != this.version.getTotalCodewords()) {
            throw FormatException.getFormatInstance();
        }
        return byArray;
    }

    boolean readModule(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n += n3;
            n2 += 4 - (n3 + 4 & 7);
        }
        if (n2 < 0) {
            n2 += n4;
            n += 4 - (n4 + 4 & 7);
        }
        this.readMappingMatrix.set(n2, n);
        return this.mappingBitMatrix.get(n2, n);
    }

    int readUtah(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (this.readModule(n - 2, n2 - 2, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n - 2, n2 - 1, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n - 1, n2 - 2, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n - 1, n2 - 1, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n - 1, n2, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n, n2 - 2, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n, n2 - 1, n3, n4)) {
            n5 |= 1;
        }
        n5 <<= 1;
        if (this.readModule(n, n2, n3, n4)) {
            n5 |= 1;
        }
        return n5;
    }

    int readCorner1(int n, int n2) {
        int n3 = 0;
        if (this.readModule(n - 1, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 1, 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 1, 2, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 2, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(1, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(2, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(3, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        return n3;
    }

    int readCorner2(int n, int n2) {
        int n3 = 0;
        if (this.readModule(n - 3, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 2, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 1, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 4, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 3, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 2, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(1, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        return n3;
    }

    int readCorner3(int n, int n2) {
        int n3 = 0;
        if (this.readModule(n - 1, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 1, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 3, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 2, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(1, n2 - 3, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(1, n2 - 2, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(1, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        return n3;
    }

    int readCorner4(int n, int n2) {
        int n3 = 0;
        if (this.readModule(n - 3, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 2, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(n - 1, 0, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 2, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(0, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(1, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(2, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.readModule(3, n2 - 1, n, n2)) {
            n3 |= 1;
        }
        return n3;
    }

    BitMatrix extractDataRegion(BitMatrix bitMatrix) {
        int n = this.version.getSymbolSizeRows();
        int n2 = this.version.getSymbolSizeColumns();
        if (bitMatrix.getHeight() != n) {
            throw new IllegalArgumentException("Dimension of bitMarix must match the version size");
        }
        int n3 = this.version.getDataRegionSizeRows();
        int n4 = this.version.getDataRegionSizeColumns();
        int n5 = n / n3;
        int n6 = n2 / n4;
        int n7 = n5 * n3;
        BitMatrix bitMatrix2 = new BitMatrix(n7);
        for (int i = 0; i < n5; ++i) {
            int n8 = i * n3;
            for (int j = 0; j < n6; ++j) {
                int n9 = j * n4;
                for (int k = 0; k < n3; ++k) {
                    int n10 = i * (n3 + 2) + 1 + k;
                    int n11 = n8 + k;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        int n12 = j * (n4 + 2) + 1 + i2;
                        if (!bitMatrix.get(n12, n10)) continue;
                        int n13 = n9 + i2;
                        bitMatrix2.set(n13, n11);
                    }
                }
            }
        }
        return bitMatrix2;
    }
}

