# 2.6. Traffic Engineering Demo (PENDING)

## Setup Test-Bed

### Setup libyang

    $ sudo apt update
    $ sudo apt-get install cmake libpcre2-dev git make build-essential
    $ mkdir -p ~/testbed
    $ cd ~/testbed
    $ git clone git@github.com:CESNET/libyang.git
    $ cd libyang
    $ git checkout v2.0.0
    $ mkdir build; cd build
    $ cmake -D CMAKE_INSTALL_PREFIX:PATH=/usr -D CMAKE_BUILD_TYPE:String="Release" ..
    $ make
    $ sudo make install


### Setup Free Range Routing

    $ sudo apt update
    $ sudo apt-get install git autoconf automake libtool make libreadline-dev texinfo    pkg-config libpam0g-dev libjson-c-dev bison flex libc-ares-dev python3-dev python3-sphinx install-info build-essential libsnmp-dev perl libcap-dev python2 libelf-dev libunwind-dev protobuf-c-compiler libprotobuf-c-dev libsystemd-dev
    $ mkdir -p ~/testbed
    $ cd ~/testbed
    $ git clone git@github.com:opensourcerouting/frr.git
    $ cd frr
    $ curl https://bootstrap.pypa.io/pip/2.7/get-pip.py --output get-pip.py
    $ sudo python2 ./get-pip.py
    $ export CFLAGS="-I /usr/local/include -g -O2"
    $ sudo rm -rf /usr/lib/frr
    $ sudo rm -rf /var/run/frr
    $ sudo mkdir -p /etc/frr
    $ sudo mkdir -p /var/run/frr
    $ sudo chown -R root:root /etc/frr
    $ ./bootstrap.sh
    $ ./configure \
        --prefix=/usr \
        --includedir=\${prefix}/include \
        --enable-exampledir=\${prefix}/share/doc/frr/examples \
        --bindir=\${prefix}/bin \
        --sbindir=\${prefix}/lib/frr \
        --libdir=\${prefix}/lib/frr \
        --libexecdir=\${prefix}/lib/frr \
        --localstatedir=/var/run/frr \
        --sysconfdir=/etc/frr \
        --with-moduledir=\${prefix}/lib/frr/modules \
        --enable-configfile-mask=0640 \
        --enable-logfile-mask=0640 \
        --enable-snmp=agentx \
        --enable-multipath=64 \
        --enable-user=root \
        --enable-group=root \
        --enable-vty-group=root \
        --enable-vtysh \
        --with-pkg-git-version \
        --with-pkg-extra-version=-MyOwnFRRVersion \
        --enable-systemd=yes \
        --enable-config-rollbacks \
        --enable-pathd \
        --enable-pcep
    $ make
    $ sudo make install


### Setup NetGen

    $ sudo apt update
    $ sudo apt-get install git ruby ruby-dev tmux gettext-base
    $ mkdir -p ~/testbed
    $ cd ~/testbed
    $ git clone git@github.com:sylane/netgen.git
    $ cd netgen
    $ git checkout teraflow
    $ sudo gem install bundler:1.15
    $ bundle _1.15_ install


### Run the Test-Bed

First load the [teraflow configuration file](./2-6-teraflow-topology.json) using the webui.
The first time the configuration is loaded may partialy fail because it tries to load the topology before the devices and links, but a second load should work.

In first console:
    $ cd ~/testbed
    $ ../tfs-ctrl/tutorial/2-6-te-demo-start-testbed.sh

Then in second console:
    $ sudo -i
    # cd /tmp/negen
    # ./tmux.sh
