from __future__ import annotations
from typing import TYPE_CHECKING
from .StringField import StringField

if TYPE_CHECKING:
    from ..model.Model import Model

class PrimaryKeyField(StringField):
    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, required=True, allow_empty=False, min_length=1, **kwargs)

    def __set__(self, instance : 'Model', value : str) -> None:
        if (self.name in instance.__dict__) and (instance.__dict__[self.name] is not None):
            raise ValueError('PrimaryKeyField cannot be modified')
        super().__set__(instance, self.validate(value))
