from __future__ import annotations
from typing import Optional, Union
from common.type_checkers.Checkers import chk_float
from .Field import Field

class FloatField(Field):
    def __init__(
        self, *args, min_value : Optional[float] = None, max_value : Optional[float] = None, **kwargs) -> None:

        super().__init__(*args, type_=float, **kwargs)
        self._min_value = None if min_value is None else \
            chk_float('FloatField.min_value', min_value)
        self._max_value = None if max_value is None else \
            chk_float('FloatField.max_value', max_value, min_value=self._min_value)

    def validate(self, value : Union[float, str], try_convert_type=False) -> float:
        value = super().validate(value)
        if value is None: return None
        if try_convert_type and isinstance(value, str): value = float(value)
        return chk_float(self.name, value, min_value=self._min_value, max_value=self._max_value)
