import logging, signal, sys, threading
from prometheus_client import start_http_server
from common.Settings import get_setting
from centralizedattackdetector.Config import (
    GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD, LOG_LEVEL, METRICS_PORT)
from centralizedattackdetector.service.CentralizedAttackDetectorService import CentralizedAttackDetectorService

terminate = threading.Event()
LOGGER = None

def signal_handler(signal, frame): # pylint: disable=redefined-outer-name
    LOGGER.warning('Terminate signal received')
    terminate.set()

def main():
    global LOGGER # pylint: disable=global-statement

    service_port = get_setting('CENTRALIZEDATTACKDETECTORSERVICE_SERVICE_PORT_GRPC', default=GRPC_SERVICE_PORT)
    max_workers  = get_setting('MAX_WORKERS',                                        default=GRPC_MAX_WORKERS )
    grace_period = get_setting('GRACE_PERIOD',                                       default=GRPC_GRACE_PERIOD)
    log_level    = get_setting('LOG_LEVEL',                                          default=LOG_LEVEL        )
    metrics_port = get_setting('METRICS_PORT',                                       default=METRICS_PORT     )

    logging.basicConfig(level=log_level)
    LOGGER = logging.getLogger(__name__)

    signal.signal(signal.SIGINT,  signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    LOGGER.info('Starting...')

    # Start metrics server
    start_http_server(metrics_port)

    # Starting CentralizedCybersecurity service
    grpc_service = CentralizedAttackDetectorService(
        port=service_port, max_workers=max_workers, grace_period=grace_period)
    grpc_service.start()

    # Wait for Ctrl+C or termination signal
    while not terminate.wait(timeout=0.1): pass

    LOGGER.info('Terminating...')
    grpc_service.stop()

    LOGGER.info('Bye')
    return 0

if __name__ == '__main__':
    sys.exit(main())
