/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingStart
extends Grouping {
    private final List<GroupingLeaf> children = new ArrayList<GroupingLeaf>();
    private final HtmlColor backColorGeneral;
    private final GroupingStart parent;

    public GroupingStart(String string, String string2, HtmlColor htmlColor, HtmlColor htmlColor2, GroupingStart groupingStart) {
        super(string, string2, GroupingType.START, htmlColor2);
        this.backColorGeneral = htmlColor;
        this.parent = groupingStart;
    }

    List<GroupingLeaf> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChildren(GroupingLeaf groupingLeaf) {
        this.children.add(groupingLeaf);
    }

    @Override
    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    @Override
    public HtmlColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    @Override
    public boolean dealWith(Participant participant) {
        return false;
    }

    @Override
    public Url getUrl() {
        return null;
    }

    @Override
    public boolean hasUrl() {
        return false;
    }

    @Override
    public boolean isParallel() {
        return this.getTitle().equals("par2");
    }
}

