from __future__ import print_function
import logging
from l3_attackmitigator.proto.l3_attackmitigator_pb2 import (
    EmptyMitigator
)
from l3_attackmitigator.proto.l3_attackmitigator_pb2_grpc import (
    L3AttackmitigatorServicer,
)

LOGGER = logging.getLogger(__name__)

class l3_attackmitigatorServiceServicerImpl(L3AttackmitigatorServicer):

    def __init__(self):
        LOGGER.debug("Creating Servicer...")
        self.last_value = -1
        self.last_tag = 0
    
    def SendOutput(self, request, context):
        # SEND CONFIDENCE TO MITIGATION SERVER
        logging.debug("")
        print("Server received mitigation values...", request.confidence)
        last_value = request.confidence
        last_tag = request.tag
        # RETURN OK TO THE CALLER
        return EmptyMitigator(
            message=f"OK, received values: {last_tag} with confidence {last_value}."
        )

    def GetMitigation(self, request, context):
        # GET OR PERFORM MITIGATION STRATEGY
        logging.debug("")
        print("Returing mitigation strategy...")
        k = self.last_value * 2
        return EmptyMitigator(
            message=f"Mitigation with double confidence = {k}"
        )


    
