import grpc, logging
from concurrent import futures

GRPC_MAX_WORKERS  = 10
GRPC_GRACE_PERIOD = 60

class MockService:
    def __init__(self, address, port, max_workers=GRPC_MAX_WORKERS, grace_period=GRPC_GRACE_PERIOD, cls_name=__name__):
        self.logger = logging.getLogger(cls_name)
        self.address = address
        self.port = port
        self.endpoint = None
        self.max_workers = max_workers
        self.grace_period = grace_period
        self.pool = None
        self.server = None

    def install_servicers(self):
        pass

    def start(self):
        self.endpoint = '{:s}:{:s}'.format(str(self.address), str(self.port))
        self.logger.info('Starting Service (tentative endpoint: {:s}, max_workers: {:s})...'.format(
            str(self.endpoint), str(self.max_workers)))

        self.pool = futures.ThreadPoolExecutor(max_workers=self.max_workers)
        self.server = grpc.server(self.pool) # , interceptors=(tracer_interceptor,))

        self.install_servicers()

        port = self.server.add_insecure_port(self.endpoint)
        self.endpoint = '{:s}:{:s}'.format(str(self.address), str(port))
        self.logger.info('Listening on {:s}...'.format(str(self.endpoint)))
        self.server.start()

        self.logger.debug('Service started')

    def stop(self):
        self.logger.debug('Stopping service (grace period {:s} seconds)...'.format(str(self.grace_period)))
        self.server.stop(self.grace_period)
        self.logger.debug('Service stopped')
