#!/bin/bash

# installing basic tools
pip install --upgrade pip setuptools wheel pip-tools pylint pytest pytest-benchmark coverage grpcio-tools

# creating an empty file
echo "" > requirements.in

#TODO: include here your component
COMPONENTS="compute context device service monitoring centralizedattackdetector opticalcentralizedattackdetector opticalattackmitigator dbscanserving"

# compiling dependencies from all components
for component in $COMPONENTS
do
    echo "computing requirements for component $component"
    diff requirements.in src/$component/requirements.in | grep '^>' | sed 's/^>\ //' >> requirements.in
done

pip-compile --output-file=requirements.txt requirements.in
python -m pip install -r requirements.txt

# removing the temporary files
rm requirements.in
rm requirements.txt
