# TeraFlow OS SDN Controller Installation Instructions 
Assuming you have a running Kubernetes deployment installed following the instructions provided in [Wiki: Installing Kubernetes on your Linux machine](../../../wikis/Installing-Kubernetes-on-your-Linux-machine), the following instructions will let you deploy TeraFlow OS SDN Controller in your local Kubernetes environment.

Among others, it is assumed that you can run the command <code> kubectl cluster-info</code> in the machine you use for running the deployment script below.


## 1. Clone the repository
Create a folder (e.g., ~/deploy-test/teraflow/controller) to place the source code, move to that folder, clone the repository, and checkout the target branch you want to deploy (e.g., master or develop):

<code>mkdir -p ~/deploy-test/teraflow/controller; cd ~/deploy-test/teraflow/controller</code>

<code>git clone https://gitlab.com/teraflow-h2020/controller.git .</code>

<code>git checkout develop</code>


## 2. Adapt deployment script
Find the script <code>deploy_to_kubernetes.sh</code> and modify the configuration settings at the top of the script according to your local Kubernetes environment.


## 3. Run the deployment script
Execute the script <code>deploy_to_kubernetes.sh</code> to build and deploy the components at your local Kubernetes environment.
