import grpc from 'k6/net/grpc';
import exec from "k6/execution";
import { check, sleep } from 'k6';

const client = new grpc.Client();
client.load(['../../../../proto'], 'automation.proto');

export const data = [];
for (let i = 1; i < 801; i++) {
  data.push({
    "devRoleType": "DEV_CONF",
    "devRoleId": {
        "devId": {"device_uuid": {"uuid": "EMU-" + i}},
        "devRoleId": {"uuid": "EMU-" + i}
    }
  });
};

export const options = {
  scenarios :{

    "ZtpAdd-scenario": {
      executor: "shared-iterations",
      vus: 800,
      iterations: data.length,
      maxDuration: "1h"
    }
  }
};

export default () => {
  client.connect('10.1.255.232:5050', {
    plaintext: true,
    timeout: 10000
  });

  var item = data[exec.scenario.iterationInInstance];
  const response = client.invoke('automation.AutomationService/ZtpDelete', item);

  check(response, {
    'status is OK': (r) => r && r.status === grpc.StatusOK,
  });

  console.log(JSON.stringify(response.message));

  client.close();
  sleep(1);
};

export function handleSummary(data) {

  return {
    'summary_delete_800.json': JSON.stringify(data.metrics.grpc_req_duration.values), //the default data object
  };
}
