# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from flask.json import jsonify
from flask_restful import Resource
from flask import request
from compute.service.rest_server.nbi_plugins.tools.Authentication import HTTP_AUTH
from compute.service.rest_server.nbi_plugins.tools.HttpStatusCodes import HTTP_OK

LOGGER = logging.getLogger(__name__)

class NSS_Service(Resource):
    @HTTP_AUTH.login_required
    def get(self, slice_id : str):
        LOGGER.debug('GET Slice ID: {:s}'.format(str(slice_id)))
        LOGGER.debug('GET Request: {:s}'.format(str(request)))
        
        # TODO Return information and status about requested slice

        response = jsonify({"message": "Requested info for slice {:s}".format(slice_id)})
        response.status_code = HTTP_OK
        return response

    @HTTP_AUTH.login_required
    def delete(self, slice_id : str):
        LOGGER.debug('DELETE Slice ID: {:s}'.format(str(slice_id)))
        LOGGER.debug('DELETE Request: {:s}'.format(str(request)))
        
        # TODO Delete the requested slice

        response = jsonify({"message": "Deletion request for slice {:s}".format(slice_id)})
        response.status_code = HTTP_OK
        return response
