# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from common.proto import monitoring_pb2
from common.proto.kpi_sample_types_pb2 import KpiSampleType

def kpi():
    _kpi                    = monitoring_pb2.Kpi()
    _kpi.kpi_id.kpi_id.uuid = 'KPIID0000'   # pylint: disable=maybe-no-member
    return _kpi

def kpi_id():
    _kpi_id             = monitoring_pb2.KpiId()
    _kpi_id.kpi_id.uuid = str(1)            # pylint: disable=maybe-no-member
    return _kpi_id

def create_kpi_request():
    _create_kpi_request                                = monitoring_pb2.KpiDescriptor()
    _create_kpi_request.kpi_description                = 'KPI Description Test'
    _create_kpi_request.kpi_sample_type                = KpiSampleType.KPISAMPLETYPE_PACKETS_TRANSMITTED
    _create_kpi_request.device_id.device_uuid.uuid     = 'DEV1'     # pylint: disable=maybe-no-member
    _create_kpi_request.service_id.service_uuid.uuid   = 'SERV1'    # pylint: disable=maybe-no-member
    _create_kpi_request.endpoint_id.endpoint_uuid.uuid = 'END1'     # pylint: disable=maybe-no-member
    return _create_kpi_request

def monitor_kpi_request(kpi_uuid, monitoring_window_s, sampling_rate_s):
    _monitor_kpi_request                     = monitoring_pb2.MonitorKpiRequest()
    _monitor_kpi_request.kpi_id.kpi_id.uuid  = kpi_uuid   # pylint: disable=maybe-no-member
    _monitor_kpi_request.monitoring_window_s = monitoring_window_s
    _monitor_kpi_request.sampling_rate_s     = sampling_rate_s
    return _monitor_kpi_request

def include_kpi_request():
    _include_kpi_request                        = monitoring_pb2.Kpi()
    _include_kpi_request.kpi_id.kpi_id.uuid     = str(1)    # pylint: disable=maybe-no-member
    _include_kpi_request.timestamp    = "2021-10-12T13:14:42Z"
    _include_kpi_request.kpi_value.intVal       = 500       # pylint: disable=maybe-no-member
    return _include_kpi_request
