# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc, logging
from common.rpc_method_wrapper.Decorator import create_metrics, safe_and_metered_rpc_method
from interdomain.proto.context_pb2 import AuthenticationResult, TeraFlowController
from interdomain.proto.slice_pb2 import SliceId, SliceStatus, TransportSlice
from interdomain.proto.interdomain_pb2_grpc import InterdomainServiceServicer

LOGGER = logging.getLogger(__name__)

SERVICE_NAME = 'Interdomain'
METHOD_NAMES = ['Authenticate', 'LookUpSlice', 'OrderSliceFromCatalog', 'CreateSliceAndAddToCatalog']
METRICS = create_metrics(SERVICE_NAME, METHOD_NAMES)

class InterdomainServiceServicerImpl(InterdomainServiceServicer):
    def __init__(self):
        LOGGER.debug('Creating Servicer...')
        LOGGER.debug('Servicer Created')

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def Authenticate(self, request : TeraFlowController, context : grpc.ServicerContext) -> AuthenticationResult:
        auth_result = AuthenticationResult()
        #auth_result.context_id = ...
        auth_result.authenticated = True
        return auth_result

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def LookUpSlice(self, request : TransportSlice, context : grpc.ServicerContext) -> SliceId:
        return SliceId()

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def OrderSliceFromCatalog(self, request : TransportSlice, context : grpc.ServicerContext) -> SliceStatus:
        return SliceStatus()

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def CreateSliceAndAddToCatalog(self, request : TransportSlice, context : grpc.ServicerContext) -> SliceStatus:
        return SliceStatus()
