# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class fatal_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/pcie/fatal-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the fatal PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__undefined_errors','__data_link_errors','__surprise_down_errors','__poisoned_tlp_errors','__flow_control_protocol_errors','__completion_timeout_errors','__completion_abort_errors','__unexpected_completion_errors','__receiver_overflow_errors','__malformed_tlp_errors','__ecrc_errors','__unsupported_request_errors','__acs_violation_errors','__internal_errors','__blocked_tlp_errors','__atomic_op_blocked_errors','__tlp_prefix_blocked_errors',)

  _yang_name = 'fatal-errors'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'fatal-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_undefined_errors(self):
    """
    Getter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/undefined_errors (oc-yang:counter64)

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__undefined_errors
      
  def _set_undefined_errors(self, v, load=False):
    """
    Setter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/undefined_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_undefined_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_undefined_errors() directly.

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """undefined_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__undefined_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_undefined_errors(self):
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_data_link_errors(self):
    """
    Getter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/data_link_errors (oc-yang:counter64)

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__data_link_errors
      
  def _set_data_link_errors(self, v, load=False):
    """
    Setter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/data_link_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_errors() directly.

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__data_link_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_errors(self):
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_surprise_down_errors(self):
    """
    Getter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/surprise_down_errors (oc-yang:counter64)

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__surprise_down_errors
      
  def _set_surprise_down_errors(self, v, load=False):
    """
    Setter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/surprise_down_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_surprise_down_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_surprise_down_errors() directly.

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """surprise_down_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__surprise_down_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_surprise_down_errors(self):
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_poisoned_tlp_errors(self):
    """
    Getter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/poisoned_tlp_errors (oc-yang:counter64)

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__poisoned_tlp_errors
      
  def _set_poisoned_tlp_errors(self, v, load=False):
    """
    Setter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/poisoned_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_poisoned_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_poisoned_tlp_errors() directly.

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """poisoned_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__poisoned_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_poisoned_tlp_errors(self):
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_flow_control_protocol_errors(self):
    """
    Getter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/flow_control_protocol_errors (oc-yang:counter64)

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__flow_control_protocol_errors
      
  def _set_flow_control_protocol_errors(self, v, load=False):
    """
    Setter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/flow_control_protocol_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flow_control_protocol_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flow_control_protocol_errors() directly.

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flow_control_protocol_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__flow_control_protocol_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flow_control_protocol_errors(self):
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_timeout_errors(self):
    """
    Getter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_timeout_errors (oc-yang:counter64)

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_timeout_errors
      
  def _set_completion_timeout_errors(self, v, load=False):
    """
    Setter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_timeout_errors() directly.

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_timeout_errors(self):
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_abort_errors(self):
    """
    Getter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_abort_errors (oc-yang:counter64)

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_abort_errors
      
  def _set_completion_abort_errors(self, v, load=False):
    """
    Setter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_abort_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_abort_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_abort_errors() directly.

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_abort_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_abort_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_abort_errors(self):
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unexpected_completion_errors(self):
    """
    Getter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unexpected_completion_errors (oc-yang:counter64)

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unexpected_completion_errors
      
  def _set_unexpected_completion_errors(self, v, load=False):
    """
    Setter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unexpected_completion_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unexpected_completion_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unexpected_completion_errors() directly.

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unexpected_completion_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unexpected_completion_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unexpected_completion_errors(self):
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_overflow_errors(self):
    """
    Getter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/receiver_overflow_errors (oc-yang:counter64)

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__receiver_overflow_errors
      
  def _set_receiver_overflow_errors(self, v, load=False):
    """
    Setter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/receiver_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_overflow_errors() directly.

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_overflow_errors(self):
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_malformed_tlp_errors(self):
    """
    Getter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/malformed_tlp_errors (oc-yang:counter64)

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__malformed_tlp_errors
      
  def _set_malformed_tlp_errors(self, v, load=False):
    """
    Setter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/malformed_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_malformed_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_malformed_tlp_errors() directly.

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """malformed_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__malformed_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_malformed_tlp_errors(self):
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_ecrc_errors(self):
    """
    Getter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/ecrc_errors (oc-yang:counter64)

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__ecrc_errors
      
  def _set_ecrc_errors(self, v, load=False):
    """
    Setter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/ecrc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ecrc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ecrc_errors() directly.

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ecrc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__ecrc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ecrc_errors(self):
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unsupported_request_errors(self):
    """
    Getter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unsupported_request_errors (oc-yang:counter64)

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unsupported_request_errors
      
  def _set_unsupported_request_errors(self, v, load=False):
    """
    Setter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unsupported_request_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unsupported_request_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unsupported_request_errors() directly.

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unsupported_request_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unsupported_request_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unsupported_request_errors(self):
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_acs_violation_errors(self):
    """
    Getter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/acs_violation_errors (oc-yang:counter64)

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__acs_violation_errors
      
  def _set_acs_violation_errors(self, v, load=False):
    """
    Setter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/acs_violation_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acs_violation_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acs_violation_errors() directly.

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acs_violation_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__acs_violation_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acs_violation_errors(self):
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_blocked_tlp_errors(self):
    """
    Getter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/blocked_tlp_errors (oc-yang:counter64)

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__blocked_tlp_errors
      
  def _set_blocked_tlp_errors(self, v, load=False):
    """
    Setter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/blocked_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_blocked_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_blocked_tlp_errors() directly.

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """blocked_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__blocked_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_blocked_tlp_errors(self):
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_atomic_op_blocked_errors(self):
    """
    Getter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    return self.__atomic_op_blocked_errors
      
  def _set_atomic_op_blocked_errors(self, v, load=False):
    """
    Setter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_atomic_op_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_atomic_op_blocked_errors() directly.

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """atomic_op_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__atomic_op_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_atomic_op_blocked_errors(self):
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_tlp_prefix_blocked_errors(self):
    """
    Getter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__tlp_prefix_blocked_errors
      
  def _set_tlp_prefix_blocked_errors(self, v, load=False):
    """
    Setter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlp_prefix_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlp_prefix_blocked_errors() directly.

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlp_prefix_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tlp_prefix_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlp_prefix_blocked_errors(self):
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  undefined_errors = __builtin__.property(_get_undefined_errors)
  data_link_errors = __builtin__.property(_get_data_link_errors)
  surprise_down_errors = __builtin__.property(_get_surprise_down_errors)
  poisoned_tlp_errors = __builtin__.property(_get_poisoned_tlp_errors)
  flow_control_protocol_errors = __builtin__.property(_get_flow_control_protocol_errors)
  completion_timeout_errors = __builtin__.property(_get_completion_timeout_errors)
  completion_abort_errors = __builtin__.property(_get_completion_abort_errors)
  unexpected_completion_errors = __builtin__.property(_get_unexpected_completion_errors)
  receiver_overflow_errors = __builtin__.property(_get_receiver_overflow_errors)
  malformed_tlp_errors = __builtin__.property(_get_malformed_tlp_errors)
  ecrc_errors = __builtin__.property(_get_ecrc_errors)
  unsupported_request_errors = __builtin__.property(_get_unsupported_request_errors)
  acs_violation_errors = __builtin__.property(_get_acs_violation_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  blocked_tlp_errors = __builtin__.property(_get_blocked_tlp_errors)
  atomic_op_blocked_errors = __builtin__.property(_get_atomic_op_blocked_errors)
  tlp_prefix_blocked_errors = __builtin__.property(_get_tlp_prefix_blocked_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('undefined_errors', undefined_errors), ('data_link_errors', data_link_errors), ('surprise_down_errors', surprise_down_errors), ('poisoned_tlp_errors', poisoned_tlp_errors), ('flow_control_protocol_errors', flow_control_protocol_errors), ('completion_timeout_errors', completion_timeout_errors), ('completion_abort_errors', completion_abort_errors), ('unexpected_completion_errors', unexpected_completion_errors), ('receiver_overflow_errors', receiver_overflow_errors), ('malformed_tlp_errors', malformed_tlp_errors), ('ecrc_errors', ecrc_errors), ('unsupported_request_errors', unsupported_request_errors), ('acs_violation_errors', acs_violation_errors), ('internal_errors', internal_errors), ('blocked_tlp_errors', blocked_tlp_errors), ('atomic_op_blocked_errors', atomic_op_blocked_errors), ('tlp_prefix_blocked_errors', tlp_prefix_blocked_errors), ])


class fatal_errors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/state/pcie/fatal-errors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The count of the fatal PCIe errors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_errors','__undefined_errors','__data_link_errors','__surprise_down_errors','__poisoned_tlp_errors','__flow_control_protocol_errors','__completion_timeout_errors','__completion_abort_errors','__unexpected_completion_errors','__receiver_overflow_errors','__malformed_tlp_errors','__ecrc_errors','__unsupported_request_errors','__acs_violation_errors','__internal_errors','__blocked_tlp_errors','__atomic_op_blocked_errors','__tlp_prefix_blocked_errors',)

  _yang_name = 'fatal-errors'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'pcie', 'fatal-errors']

  def _get_total_errors(self):
    """
    Getter method for total_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/total_errors (oc-yang:counter64)

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__total_errors
      
  def _set_total_errors(self, v, load=False):
    """
    Setter method for total_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/total_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_errors() directly.

    YANG Description: Total number of uncorrectable errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__total_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_errors(self):
    self.__total_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_undefined_errors(self):
    """
    Getter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/undefined_errors (oc-yang:counter64)

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__undefined_errors
      
  def _set_undefined_errors(self, v, load=False):
    """
    Setter method for undefined_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/undefined_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_undefined_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_undefined_errors() directly.

    YANG Description: Number of undefined errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """undefined_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__undefined_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_undefined_errors(self):
    self.__undefined_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="undefined-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_data_link_errors(self):
    """
    Getter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/data_link_errors (oc-yang:counter64)

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__data_link_errors
      
  def _set_data_link_errors(self, v, load=False):
    """
    Setter method for data_link_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/data_link_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_data_link_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_data_link_errors() directly.

    YANG Description: Number of data-link errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """data_link_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__data_link_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_data_link_errors(self):
    self.__data_link_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="data-link-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_surprise_down_errors(self):
    """
    Getter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/surprise_down_errors (oc-yang:counter64)

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__surprise_down_errors
      
  def _set_surprise_down_errors(self, v, load=False):
    """
    Setter method for surprise_down_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/surprise_down_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_surprise_down_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_surprise_down_errors() directly.

    YANG Description: Number of unexpected link down errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """surprise_down_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__surprise_down_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_surprise_down_errors(self):
    self.__surprise_down_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="surprise-down-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_poisoned_tlp_errors(self):
    """
    Getter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/poisoned_tlp_errors (oc-yang:counter64)

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__poisoned_tlp_errors
      
  def _set_poisoned_tlp_errors(self, v, load=False):
    """
    Setter method for poisoned_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/poisoned_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_poisoned_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_poisoned_tlp_errors() directly.

    YANG Description: Number of poisoned TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """poisoned_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__poisoned_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_poisoned_tlp_errors(self):
    self.__poisoned_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="poisoned-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_flow_control_protocol_errors(self):
    """
    Getter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/flow_control_protocol_errors (oc-yang:counter64)

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__flow_control_protocol_errors
      
  def _set_flow_control_protocol_errors(self, v, load=False):
    """
    Setter method for flow_control_protocol_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/flow_control_protocol_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flow_control_protocol_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flow_control_protocol_errors() directly.

    YANG Description: Number of flow control protocol errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flow_control_protocol_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__flow_control_protocol_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flow_control_protocol_errors(self):
    self.__flow_control_protocol_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="flow-control-protocol-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_timeout_errors(self):
    """
    Getter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_timeout_errors (oc-yang:counter64)

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_timeout_errors
      
  def _set_completion_timeout_errors(self, v, load=False):
    """
    Setter method for completion_timeout_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_timeout_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_timeout_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_timeout_errors() directly.

    YANG Description: Number of completion timeout errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_timeout_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_timeout_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_timeout_errors(self):
    self.__completion_timeout_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-timeout-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_completion_abort_errors(self):
    """
    Getter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_abort_errors (oc-yang:counter64)

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__completion_abort_errors
      
  def _set_completion_abort_errors(self, v, load=False):
    """
    Setter method for completion_abort_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/completion_abort_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_completion_abort_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_completion_abort_errors() directly.

    YANG Description: Number of completion abort errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """completion_abort_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__completion_abort_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_completion_abort_errors(self):
    self.__completion_abort_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="completion-abort-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unexpected_completion_errors(self):
    """
    Getter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unexpected_completion_errors (oc-yang:counter64)

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unexpected_completion_errors
      
  def _set_unexpected_completion_errors(self, v, load=False):
    """
    Setter method for unexpected_completion_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unexpected_completion_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unexpected_completion_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unexpected_completion_errors() directly.

    YANG Description: Number of unexpected completion errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unexpected_completion_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unexpected_completion_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unexpected_completion_errors(self):
    self.__unexpected_completion_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unexpected-completion-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_receiver_overflow_errors(self):
    """
    Getter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/receiver_overflow_errors (oc-yang:counter64)

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__receiver_overflow_errors
      
  def _set_receiver_overflow_errors(self, v, load=False):
    """
    Setter method for receiver_overflow_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/receiver_overflow_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_receiver_overflow_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_receiver_overflow_errors() directly.

    YANG Description: Number of receiver overflow errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """receiver_overflow_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__receiver_overflow_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_receiver_overflow_errors(self):
    self.__receiver_overflow_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="receiver-overflow-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_malformed_tlp_errors(self):
    """
    Getter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/malformed_tlp_errors (oc-yang:counter64)

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__malformed_tlp_errors
      
  def _set_malformed_tlp_errors(self, v, load=False):
    """
    Setter method for malformed_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/malformed_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_malformed_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_malformed_tlp_errors() directly.

    YANG Description: Number of malformed TLP errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """malformed_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__malformed_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_malformed_tlp_errors(self):
    self.__malformed_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="malformed-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_ecrc_errors(self):
    """
    Getter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/ecrc_errors (oc-yang:counter64)

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    return self.__ecrc_errors
      
  def _set_ecrc_errors(self, v, load=False):
    """
    Setter method for ecrc_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/ecrc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ecrc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ecrc_errors() directly.

    YANG Description: Number of ECRC errors detected by PCIe device since the system
booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ecrc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__ecrc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ecrc_errors(self):
    self.__ecrc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="ecrc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_unsupported_request_errors(self):
    """
    Getter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unsupported_request_errors (oc-yang:counter64)

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__unsupported_request_errors
      
  def _set_unsupported_request_errors(self, v, load=False):
    """
    Setter method for unsupported_request_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/unsupported_request_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unsupported_request_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unsupported_request_errors() directly.

    YANG Description: Number of unsupported request errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unsupported_request_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__unsupported_request_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unsupported_request_errors(self):
    self.__unsupported_request_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unsupported-request-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_acs_violation_errors(self):
    """
    Getter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/acs_violation_errors (oc-yang:counter64)

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__acs_violation_errors
      
  def _set_acs_violation_errors(self, v, load=False):
    """
    Setter method for acs_violation_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/acs_violation_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_acs_violation_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_acs_violation_errors() directly.

    YANG Description: Number of access control errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """acs_violation_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__acs_violation_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_acs_violation_errors(self):
    self.__acs_violation_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="acs-violation-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_internal_errors(self):
    """
    Getter method for internal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/internal_errors (oc-yang:counter64)

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    return self.__internal_errors
      
  def _set_internal_errors(self, v, load=False):
    """
    Setter method for internal_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/internal_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_internal_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_internal_errors() directly.

    YANG Description: Number of internal errors detected by PCIe device since the
system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """internal_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__internal_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_internal_errors(self):
    self.__internal_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="internal-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_blocked_tlp_errors(self):
    """
    Getter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/blocked_tlp_errors (oc-yang:counter64)

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    return self.__blocked_tlp_errors
      
  def _set_blocked_tlp_errors(self, v, load=False):
    """
    Setter method for blocked_tlp_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/blocked_tlp_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_blocked_tlp_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_blocked_tlp_errors() directly.

    YANG Description: Number of blocked TLP errors detected by PCIe device since
the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """blocked_tlp_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__blocked_tlp_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_blocked_tlp_errors(self):
    self.__blocked_tlp_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="blocked-tlp-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_atomic_op_blocked_errors(self):
    """
    Getter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    return self.__atomic_op_blocked_errors
      
  def _set_atomic_op_blocked_errors(self, v, load=False):
    """
    Setter method for atomic_op_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/atomic_op_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_atomic_op_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_atomic_op_blocked_errors() directly.

    YANG Description: Number of atomic operation blocked errors detected by PCIe
device since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """atomic_op_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__atomic_op_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_atomic_op_blocked_errors(self):
    self.__atomic_op_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="atomic-op-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)


  def _get_tlp_prefix_blocked_errors(self):
    """
    Getter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    return self.__tlp_prefix_blocked_errors
      
  def _set_tlp_prefix_blocked_errors(self, v, load=False):
    """
    Setter method for tlp_prefix_blocked_errors, mapped from YANG variable /components/component/state/pcie/fatal_errors/tlp_prefix_blocked_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlp_prefix_blocked_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlp_prefix_blocked_errors() directly.

    YANG Description: Number of TLP prefix blocked errors detected by PCIe device
since the system booted, according to PCIe AER driver.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlp_prefix_blocked_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__tlp_prefix_blocked_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlp_prefix_blocked_errors(self):
    self.__tlp_prefix_blocked_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlp-prefix-blocked-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-yang:counter64', is_config=False)

  total_errors = __builtin__.property(_get_total_errors)
  undefined_errors = __builtin__.property(_get_undefined_errors)
  data_link_errors = __builtin__.property(_get_data_link_errors)
  surprise_down_errors = __builtin__.property(_get_surprise_down_errors)
  poisoned_tlp_errors = __builtin__.property(_get_poisoned_tlp_errors)
  flow_control_protocol_errors = __builtin__.property(_get_flow_control_protocol_errors)
  completion_timeout_errors = __builtin__.property(_get_completion_timeout_errors)
  completion_abort_errors = __builtin__.property(_get_completion_abort_errors)
  unexpected_completion_errors = __builtin__.property(_get_unexpected_completion_errors)
  receiver_overflow_errors = __builtin__.property(_get_receiver_overflow_errors)
  malformed_tlp_errors = __builtin__.property(_get_malformed_tlp_errors)
  ecrc_errors = __builtin__.property(_get_ecrc_errors)
  unsupported_request_errors = __builtin__.property(_get_unsupported_request_errors)
  acs_violation_errors = __builtin__.property(_get_acs_violation_errors)
  internal_errors = __builtin__.property(_get_internal_errors)
  blocked_tlp_errors = __builtin__.property(_get_blocked_tlp_errors)
  atomic_op_blocked_errors = __builtin__.property(_get_atomic_op_blocked_errors)
  tlp_prefix_blocked_errors = __builtin__.property(_get_tlp_prefix_blocked_errors)


  _pyangbind_elements = OrderedDict([('total_errors', total_errors), ('undefined_errors', undefined_errors), ('data_link_errors', data_link_errors), ('surprise_down_errors', surprise_down_errors), ('poisoned_tlp_errors', poisoned_tlp_errors), ('flow_control_protocol_errors', flow_control_protocol_errors), ('completion_timeout_errors', completion_timeout_errors), ('completion_abort_errors', completion_abort_errors), ('unexpected_completion_errors', unexpected_completion_errors), ('receiver_overflow_errors', receiver_overflow_errors), ('malformed_tlp_errors', malformed_tlp_errors), ('ecrc_errors', ecrc_errors), ('unsupported_request_errors', unsupported_request_errors), ('acs_violation_errors', acs_violation_errors), ('internal_errors', internal_errors), ('blocked_tlp_errors', blocked_tlp_errors), ('atomic_op_blocked_errors', atomic_op_blocked_errors), ('tlp_prefix_blocked_errors', tlp_prefix_blocked_errors), ])


