# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class memory(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/memory. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
  """
  __slots__ = ('_path_helper', '_extmethods', '__available','__utilized',)

  _yang_name = 'memory'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'memory']

  def _get_available(self):
    """
    Getter method for available, mapped from YANG variable /components/component/state/memory/available (uint64)

    YANG Description: The available memory physically installed, or logically
allocated to the component.
    """
    return self.__available
      
  def _set_available(self, v, load=False):
    """
    Setter method for available, mapped from YANG variable /components/component/state/memory/available (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_available is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_available() directly.

    YANG Description: The available memory physically installed, or logically
allocated to the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """available must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__available = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_available(self):
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_utilized(self):
    """
    Getter method for utilized, mapped from YANG variable /components/component/state/memory/utilized (uint64)

    YANG Description: The memory currently in use by processes running on
the component, not considering reserved memory that is
not available for use.
    """
    return self.__utilized
      
  def _set_utilized(self, v, load=False):
    """
    Setter method for utilized, mapped from YANG variable /components/component/state/memory/utilized (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilized is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilized() directly.

    YANG Description: The memory currently in use by processes running on
the component, not considering reserved memory that is
not available for use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilized must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__utilized = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilized(self):
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)

  available = __builtin__.property(_get_available)
  utilized = __builtin__.property(_get_utilized)


  _pyangbind_elements = OrderedDict([('available', available), ('utilized', utilized), ])


class memory(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/state/memory. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: For components that have associated memory, these values
report information about available and utilized memory.
  """
  __slots__ = ('_path_helper', '_extmethods', '__available','__utilized',)

  _yang_name = 'memory'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'memory']

  def _get_available(self):
    """
    Getter method for available, mapped from YANG variable /components/component/state/memory/available (uint64)

    YANG Description: The available memory physically installed, or logically
allocated to the component.
    """
    return self.__available
      
  def _set_available(self, v, load=False):
    """
    Setter method for available, mapped from YANG variable /components/component/state/memory/available (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_available is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_available() directly.

    YANG Description: The available memory physically installed, or logically
allocated to the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """available must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__available = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_available(self):
    self.__available = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="available", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_utilized(self):
    """
    Getter method for utilized, mapped from YANG variable /components/component/state/memory/utilized (uint64)

    YANG Description: The memory currently in use by processes running on
the component, not considering reserved memory that is
not available for use.
    """
    return self.__utilized
      
  def _set_utilized(self, v, load=False):
    """
    Setter method for utilized, mapped from YANG variable /components/component/state/memory/utilized (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilized is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilized() directly.

    YANG Description: The memory currently in use by processes running on
the component, not considering reserved memory that is
not available for use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilized must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__utilized = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilized(self):
    self.__utilized = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="utilized", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)

  available = __builtin__.property(_get_available)
  utilized = __builtin__.property(_get_utilized)


  _pyangbind_elements = OrderedDict([('available', available), ('utilized', utilized), ])


