# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import utilization
class chassis(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for chassis components
  """
  __slots__ = ('_path_helper', '_extmethods', '__utilization',)

  _yang_name = 'chassis'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__utilization = YANGDynClass(base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis']

  def _get_utilization(self):
    """
    Getter method for utilization, mapped from YANG variable /components/component/chassis/utilization (container)

    YANG Description: Utilization of the component.
    """
    return self.__utilization
      
  def _set_utilization(self, v, load=False):
    """
    Setter method for utilization, mapped from YANG variable /components/component/chassis/utilization (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilization() directly.

    YANG Description: Utilization of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilization must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilization(self):
    self.__utilization = YANGDynClass(base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  utilization = __builtin__.property(_get_utilization, _set_utilization)


  _pyangbind_elements = OrderedDict([('utilization', utilization), ])


from . import utilization
class chassis(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/chassis. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data for chassis components
  """
  __slots__ = ('_path_helper', '_extmethods', '__utilization',)

  _yang_name = 'chassis'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__utilization = YANGDynClass(base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis']

  def _get_utilization(self):
    """
    Getter method for utilization, mapped from YANG variable /components/component/chassis/utilization (container)

    YANG Description: Utilization of the component.
    """
    return self.__utilization
      
  def _set_utilization(self, v, load=False):
    """
    Setter method for utilization, mapped from YANG variable /components/component/chassis/utilization (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_utilization is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_utilization() directly.

    YANG Description: Utilization of the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """utilization must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__utilization = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_utilization(self):
    self.__utilization = YANGDynClass(base=utilization.utilization, is_container='container', yang_name="utilization", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  utilization = __builtin__.property(_get_utilization, _set_utilization)


  _pyangbind_elements = OrderedDict([('utilization', utilization), ])


