/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.data.DataPlot;
import jcckit.graphic.Anchor;
import jcckit.graphic.ClippingRectangle;
import jcckit.plot.Plot;
import jcckit.plot.PlotEvent;
import jcckit.plot.PlotListener;
import jcckit.util.ConfigParameters;

public class PlotCanvas
implements PlotListener {
    public static final String PAPER_KEY = "paper";
    public static final String HORIZONTAL_ANCHOR_KEY = "horizontalAnchor";
    public static final String VERTICAL_ANCHOR_KEY = "verticalAnchor";
    public static final String PLOT_KEY = "plot";
    private final ClippingRectangle _paper;
    private final Anchor _horizontalAnchor;
    private final Anchor _verticalAnchor;
    private final Plot _plot;

    public PlotCanvas(ConfigParameters configParameters) {
        double[] dArray = configParameters.getDoubleArray(PAPER_KEY, new double[]{0.0, 0.0, 1.0, 0.6});
        this._paper = new ClippingRectangle(dArray[0], dArray[1], dArray[2], dArray[3]);
        this._horizontalAnchor = Anchor.getHorizontalAnchor(configParameters, HORIZONTAL_ANCHOR_KEY, Anchor.CENTER);
        this._verticalAnchor = Anchor.getVerticalAnchor(configParameters, VERTICAL_ANCHOR_KEY, Anchor.CENTER);
        this._plot = new Plot(configParameters.getNode(PLOT_KEY));
        this._plot.addPlotListener(this);
    }

    public ClippingRectangle getPaper() {
        return this._paper;
    }

    public Anchor getHorizontalAnchor() {
        return this._horizontalAnchor;
    }

    public Anchor getVerticalAnchor() {
        return this._verticalAnchor;
    }

    public Plot getPlot() {
        return this._plot;
    }

    public void connect(DataPlot dataPlot) {
        this._plot.connect(dataPlot);
    }

    public void plotChanged(PlotEvent plotEvent) {
    }
}

