# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server import util


class TapiNotificationNotificationChannel(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, next_sequence_no: int=None, stream_address: str=None):  # noqa: E501
        """TapiNotificationNotificationChannel - a model defined in Swagger

        :param name: The name of this TapiNotificationNotificationChannel.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiNotificationNotificationChannel.  # noqa: E501
        :type local_id: str
        :param next_sequence_no: The next_sequence_no of this TapiNotificationNotificationChannel.  # noqa: E501
        :type next_sequence_no: int
        :param stream_address: The stream_address of this TapiNotificationNotificationChannel.  # noqa: E501
        :type stream_address: str
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'next_sequence_no': int,
            'stream_address': str
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'next_sequence_no': 'next-sequence-no',
            'stream_address': 'stream-address'
        }
        self._name = name
        self._local_id = local_id
        self._next_sequence_no = next_sequence_no
        self._stream_address = stream_address

    @classmethod
    def from_dict(cls, dikt) -> 'TapiNotificationNotificationChannel':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.notification.NotificationChannel of this TapiNotificationNotificationChannel.  # noqa: E501
        :rtype: TapiNotificationNotificationChannel
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiNotificationNotificationChannel.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiNotificationNotificationChannel.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiNotificationNotificationChannel.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiNotificationNotificationChannel.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiNotificationNotificationChannel.

        none  # noqa: E501

        :return: The local_id of this TapiNotificationNotificationChannel.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiNotificationNotificationChannel.

        none  # noqa: E501

        :param local_id: The local_id of this TapiNotificationNotificationChannel.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def next_sequence_no(self) -> int:
        """Gets the next_sequence_no of this TapiNotificationNotificationChannel.

        The sequence number of the next notification that will be published on the channel  # noqa: E501

        :return: The next_sequence_no of this TapiNotificationNotificationChannel.
        :rtype: int
        """
        return self._next_sequence_no

    @next_sequence_no.setter
    def next_sequence_no(self, next_sequence_no: int):
        """Sets the next_sequence_no of this TapiNotificationNotificationChannel.

        The sequence number of the next notification that will be published on the channel  # noqa: E501

        :param next_sequence_no: The next_sequence_no of this TapiNotificationNotificationChannel.
        :type next_sequence_no: int
        """

        self._next_sequence_no = next_sequence_no

    @property
    def stream_address(self) -> str:
        """Gets the stream_address of this TapiNotificationNotificationChannel.

        The address/location/URI of the channel/stream to which the subscribed notifications are published.                  This specifics of this is typically dependent on the implementation protocol & mechanism and hence is typed as a string.  # noqa: E501

        :return: The stream_address of this TapiNotificationNotificationChannel.
        :rtype: str
        """
        return self._stream_address

    @stream_address.setter
    def stream_address(self, stream_address: str):
        """Sets the stream_address of this TapiNotificationNotificationChannel.

        The address/location/URI of the channel/stream to which the subscribed notifications are published.                  This specifics of this is typically dependent on the implementation protocol & mechanism and hence is typed as a string.  # noqa: E501

        :param stream_address: The stream_address of this TapiNotificationNotificationChannel.
        :type stream_address: str
        """

        self._stream_address = stream_address
