# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_capacity import TapiCommonCapacity  # noqa: F401,E501
from tapi_server.models.tapi_common_forwarding_direction import TapiCommonForwardingDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_time_range import TapiCommonTimeRange  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connectivity_service_ref import TapiConnectivityConnectivityServiceRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_service_type import TapiConnectivityServiceType  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityConnectivityConstraint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, service_layer: TapiCommonLayerProtocolName=None, schedule: TapiCommonTimeRange=None, connectivity_direction: TapiCommonForwardingDirection=None, requested_capacity: TapiCommonCapacity=None, diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]=None, connection_inclusion: List[str]=None, service_level: str=None, service_type: TapiConnectivityServiceType=None, connection_exclusion: List[str]=None, coroute_inclusion: TapiConnectivityConnectivityServiceRef=None):  # noqa: E501
        """TapiConnectivityConnectivityConstraint - a model defined in Swagger

        :param service_layer: The service_layer of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type service_layer: TapiCommonLayerProtocolName
        :param schedule: The schedule of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type schedule: TapiCommonTimeRange
        :param connectivity_direction: The connectivity_direction of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type connectivity_direction: TapiCommonForwardingDirection
        :param requested_capacity: The requested_capacity of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type requested_capacity: TapiCommonCapacity
        :param diversity_exclusion: The diversity_exclusion of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]
        :param connection_inclusion: The connection_inclusion of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type connection_inclusion: List[str]
        :param service_level: The service_level of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type service_level: str
        :param service_type: The service_type of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type service_type: TapiConnectivityServiceType
        :param connection_exclusion: The connection_exclusion of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type connection_exclusion: List[str]
        :param coroute_inclusion: The coroute_inclusion of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :type coroute_inclusion: TapiConnectivityConnectivityServiceRef
        """
        self.swagger_types = {
            'service_layer': TapiCommonLayerProtocolName,
            'schedule': TapiCommonTimeRange,
            'connectivity_direction': TapiCommonForwardingDirection,
            'requested_capacity': TapiCommonCapacity,
            'diversity_exclusion': List[TapiConnectivityConnectivityServiceRef],
            'connection_inclusion': List[str],
            'service_level': str,
            'service_type': TapiConnectivityServiceType,
            'connection_exclusion': List[str],
            'coroute_inclusion': TapiConnectivityConnectivityServiceRef
        }

        self.attribute_map = {
            'service_layer': 'service-layer',
            'schedule': 'schedule',
            'connectivity_direction': 'connectivity-direction',
            'requested_capacity': 'requested-capacity',
            'diversity_exclusion': 'diversity-exclusion',
            'connection_inclusion': 'connection-inclusion',
            'service_level': 'service-level',
            'service_type': 'service-type',
            'connection_exclusion': 'connection-exclusion',
            'coroute_inclusion': 'coroute-inclusion'
        }
        self._service_layer = service_layer
        self._schedule = schedule
        self._connectivity_direction = connectivity_direction
        self._requested_capacity = requested_capacity
        self._diversity_exclusion = diversity_exclusion
        self._connection_inclusion = connection_inclusion
        self._service_level = service_level
        self._service_type = service_type
        self._connection_exclusion = connection_exclusion
        self._coroute_inclusion = coroute_inclusion

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityConnectivityConstraint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.ConnectivityConstraint of this TapiConnectivityConnectivityConstraint.  # noqa: E501
        :rtype: TapiConnectivityConnectivityConstraint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def service_layer(self) -> TapiCommonLayerProtocolName:
        """Gets the service_layer of this TapiConnectivityConnectivityConstraint.


        :return: The service_layer of this TapiConnectivityConnectivityConstraint.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._service_layer

    @service_layer.setter
    def service_layer(self, service_layer: TapiCommonLayerProtocolName):
        """Sets the service_layer of this TapiConnectivityConnectivityConstraint.


        :param service_layer: The service_layer of this TapiConnectivityConnectivityConstraint.
        :type service_layer: TapiCommonLayerProtocolName
        """

        self._service_layer = service_layer

    @property
    def schedule(self) -> TapiCommonTimeRange:
        """Gets the schedule of this TapiConnectivityConnectivityConstraint.


        :return: The schedule of this TapiConnectivityConnectivityConstraint.
        :rtype: TapiCommonTimeRange
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule: TapiCommonTimeRange):
        """Sets the schedule of this TapiConnectivityConnectivityConstraint.


        :param schedule: The schedule of this TapiConnectivityConnectivityConstraint.
        :type schedule: TapiCommonTimeRange
        """

        self._schedule = schedule

    @property
    def connectivity_direction(self) -> TapiCommonForwardingDirection:
        """Gets the connectivity_direction of this TapiConnectivityConnectivityConstraint.


        :return: The connectivity_direction of this TapiConnectivityConnectivityConstraint.
        :rtype: TapiCommonForwardingDirection
        """
        return self._connectivity_direction

    @connectivity_direction.setter
    def connectivity_direction(self, connectivity_direction: TapiCommonForwardingDirection):
        """Sets the connectivity_direction of this TapiConnectivityConnectivityConstraint.


        :param connectivity_direction: The connectivity_direction of this TapiConnectivityConnectivityConstraint.
        :type connectivity_direction: TapiCommonForwardingDirection
        """

        self._connectivity_direction = connectivity_direction

    @property
    def requested_capacity(self) -> TapiCommonCapacity:
        """Gets the requested_capacity of this TapiConnectivityConnectivityConstraint.


        :return: The requested_capacity of this TapiConnectivityConnectivityConstraint.
        :rtype: TapiCommonCapacity
        """
        return self._requested_capacity

    @requested_capacity.setter
    def requested_capacity(self, requested_capacity: TapiCommonCapacity):
        """Sets the requested_capacity of this TapiConnectivityConnectivityConstraint.


        :param requested_capacity: The requested_capacity of this TapiConnectivityConnectivityConstraint.
        :type requested_capacity: TapiCommonCapacity
        """

        self._requested_capacity = requested_capacity

    @property
    def diversity_exclusion(self) -> List[TapiConnectivityConnectivityServiceRef]:
        """Gets the diversity_exclusion of this TapiConnectivityConnectivityConstraint.

        none  # noqa: E501

        :return: The diversity_exclusion of this TapiConnectivityConnectivityConstraint.
        :rtype: List[TapiConnectivityConnectivityServiceRef]
        """
        return self._diversity_exclusion

    @diversity_exclusion.setter
    def diversity_exclusion(self, diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]):
        """Sets the diversity_exclusion of this TapiConnectivityConnectivityConstraint.

        none  # noqa: E501

        :param diversity_exclusion: The diversity_exclusion of this TapiConnectivityConnectivityConstraint.
        :type diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]
        """

        self._diversity_exclusion = diversity_exclusion

    @property
    def connection_inclusion(self) -> List[str]:
        """Gets the connection_inclusion of this TapiConnectivityConnectivityConstraint.

        A ConnectivityService may use one or more existing Connections.                  A common traditional strategy is to set up “stranded” connectivity in the core of the network as “express channels” (this is essentially a serial compound link, but can be treated as simple connections)                  A connection inclusion capability allows for adoption of a discovered Connections.                  A ConnectivityService is requested with a connection inclusion constraint that identifies a connection (or chain of connections) that is bounded by CEPs that each belong to a NEP that references a SIP that is referenced by a CSEP of the ConnectivityService such that all CSEPs are satisfied by CEPs of the existing Connection. will allow discovered Connections with no stated intent to be associated with an intent via the ConnectivityService.  # noqa: E501

        :return: The connection_inclusion of this TapiConnectivityConnectivityConstraint.
        :rtype: List[str]
        """
        return self._connection_inclusion

    @connection_inclusion.setter
    def connection_inclusion(self, connection_inclusion: List[str]):
        """Sets the connection_inclusion of this TapiConnectivityConnectivityConstraint.

        A ConnectivityService may use one or more existing Connections.                  A common traditional strategy is to set up “stranded” connectivity in the core of the network as “express channels” (this is essentially a serial compound link, but can be treated as simple connections)                  A connection inclusion capability allows for adoption of a discovered Connections.                  A ConnectivityService is requested with a connection inclusion constraint that identifies a connection (or chain of connections) that is bounded by CEPs that each belong to a NEP that references a SIP that is referenced by a CSEP of the ConnectivityService such that all CSEPs are satisfied by CEPs of the existing Connection. will allow discovered Connections with no stated intent to be associated with an intent via the ConnectivityService.  # noqa: E501

        :param connection_inclusion: The connection_inclusion of this TapiConnectivityConnectivityConstraint.
        :type connection_inclusion: List[str]
        """

        self._connection_inclusion = connection_inclusion

    @property
    def service_level(self) -> str:
        """Gets the service_level of this TapiConnectivityConnectivityConstraint.

        An abstract value the meaning of which is mutually agreed – typically represents metrics such as - Class of service, priority, resiliency, availability  # noqa: E501

        :return: The service_level of this TapiConnectivityConnectivityConstraint.
        :rtype: str
        """
        return self._service_level

    @service_level.setter
    def service_level(self, service_level: str):
        """Sets the service_level of this TapiConnectivityConnectivityConstraint.

        An abstract value the meaning of which is mutually agreed – typically represents metrics such as - Class of service, priority, resiliency, availability  # noqa: E501

        :param service_level: The service_level of this TapiConnectivityConnectivityConstraint.
        :type service_level: str
        """

        self._service_level = service_level

    @property
    def service_type(self) -> TapiConnectivityServiceType:
        """Gets the service_type of this TapiConnectivityConnectivityConstraint.


        :return: The service_type of this TapiConnectivityConnectivityConstraint.
        :rtype: TapiConnectivityServiceType
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type: TapiConnectivityServiceType):
        """Sets the service_type of this TapiConnectivityConnectivityConstraint.


        :param service_type: The service_type of this TapiConnectivityConnectivityConstraint.
        :type service_type: TapiConnectivityServiceType
        """

        self._service_type = service_type

    @property
    def connection_exclusion(self) -> List[str]:
        """Gets the connection_exclusion of this TapiConnectivityConnectivityConstraint.

        none  # noqa: E501

        :return: The connection_exclusion of this TapiConnectivityConnectivityConstraint.
        :rtype: List[str]
        """
        return self._connection_exclusion

    @connection_exclusion.setter
    def connection_exclusion(self, connection_exclusion: List[str]):
        """Sets the connection_exclusion of this TapiConnectivityConnectivityConstraint.

        none  # noqa: E501

        :param connection_exclusion: The connection_exclusion of this TapiConnectivityConnectivityConstraint.
        :type connection_exclusion: List[str]
        """

        self._connection_exclusion = connection_exclusion

    @property
    def coroute_inclusion(self) -> TapiConnectivityConnectivityServiceRef:
        """Gets the coroute_inclusion of this TapiConnectivityConnectivityConstraint.


        :return: The coroute_inclusion of this TapiConnectivityConnectivityConstraint.
        :rtype: TapiConnectivityConnectivityServiceRef
        """
        return self._coroute_inclusion

    @coroute_inclusion.setter
    def coroute_inclusion(self, coroute_inclusion: TapiConnectivityConnectivityServiceRef):
        """Sets the coroute_inclusion of this TapiConnectivityConnectivityConstraint.


        :param coroute_inclusion: The coroute_inclusion of this TapiConnectivityConnectivityConstraint.
        :type coroute_inclusion: TapiConnectivityConnectivityServiceRef
        """

        self._coroute_inclusion = coroute_inclusion
