import logging
from typing import Dict #, List
from common.orm.fields.PrimaryKeyField import PrimaryKeyField
from common.orm.fields.StringField import StringField
from common.orm.model.Model import Model

LOGGER = logging.getLogger(__name__)

class ContextModel(Model):
    pk = PrimaryKeyField()
    context_uuid = StringField(required=True, allow_empty=False)

    def dump_id(self) -> Dict:
        return {'context_uuid': {'uuid': self.context_uuid}}

#    def dump_service_ids(self) -> List[Dict]:
#        from .ServiceModel import ServiceModel # pylint: disable=import-outside-toplevel
#        db_service_pks = self.references(ServiceModel)
#        return [ServiceModel(self.database, pk).dump_id() for pk,_ in db_service_pks]
#
#    def dump_topology_ids(self) -> List[Dict]:
#        from .TopologyModel import TopologyModel # pylint: disable=import-outside-toplevel
#        db_topology_pks = self.references(TopologyModel)
#        return [TopologyModel(self.database, pk).dump_id() for pk,_ in db_topology_pks]
#
#    def dump(self, include_services=True, include_topologies=True) -> Dict: # pylint: disable=arguments-differ
#        result = {'context_id': self.dump_id()}
#        if include_services: result['service_ids'] = self.dump_service_ids()
#        if include_topologies: result['topology_ids'] = self.dump_topology_ids()
#        return result
