/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Rectangle;
import jcckit.plot.Hint;
import jcckit.plot.PositionHint;
import jcckit.plot.Symbol;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class ErrorBarFactory
implements SymbolFactory {
    public static final String SYMBOL_FACTORY_KEY = "symbolFactory";
    private final SymbolFactory _symbolFactory;
    private final GraphicAttributes _attributes;
    private final double _size;

    public ErrorBarFactory(ConfigParameters configParameters) {
        this._symbolFactory = (SymbolFactory)Factory.createOrGet(configParameters.getNode(SYMBOL_FACTORY_KEY), null);
        this._size = configParameters.getDouble("size", 0.0);
        this._attributes = (GraphicAttributes)Factory.createOrGet(configParameters.getNode("attributes"), null);
    }

    public GraphicalElement createLegendSymbol(GraphPoint graphPoint, double d) {
        return this._symbolFactory == null ? new GraphicalComposite(null) : this._symbolFactory.createLegendSymbol(graphPoint, d);
    }

    public Symbol createSymbol(GraphPoint graphPoint, Hint hint, Hint hint2) {
        GraphPoint graphPoint2 = new GraphPoint(null);
        GraphPoint graphPoint3 = null;
        if (hint2 instanceof PositionHint) {
            graphPoint2 = ((PositionHint)hint2).getOrigin();
            graphPoint3 = ((PositionHint)hint2).getPosition();
        }
        if (graphPoint3 == null) {
            if (this._symbolFactory == null) {
                return new Symbol(new GraphicalComposite(null), hint, new PositionHint(graphPoint2, graphPoint));
            }
            return this._symbolFactory.createSymbol(graphPoint, hint, new PositionHint(graphPoint2, graphPoint));
        }
        double d = graphPoint.getX() - graphPoint2.getX();
        double d2 = graphPoint.getY() - graphPoint2.getY();
        GraphicalComposite graphicalComposite = new GraphicalComposite(null);
        if (d > 0.0) {
            graphicalComposite.addElement(new Rectangle(graphPoint3, 2.0 * d, this._size, this._attributes));
        }
        if (d2 > 0.0) {
            graphicalComposite.addElement(new Rectangle(graphPoint3, this._size, 2.0 * d2, this._attributes));
        }
        return new Symbol(graphicalComposite, hint, new PositionHint(graphPoint2, null));
    }
}

