# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class underlay(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/underlay. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State attributes for the TE link underlay.
  """
  __slots__ = ('_path_helper', '_extmethods', '__dynamic','__committed',)

  _yang_name = 'underlay'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__dynamic = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dynamic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    self.__committed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'underlay']

  def _get_dynamic(self):
    """
    Getter method for dynamic, mapped from YANG variable /networks/network/link/te/underlay/dynamic (boolean)

    YANG Description: 'true' if the underlay is dynamically created.
    """
    return self.__dynamic
      
  def _set_dynamic(self, v, load=False):
    """
    Setter method for dynamic, mapped from YANG variable /networks/network/link/te/underlay/dynamic (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dynamic is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dynamic() directly.

    YANG Description: 'true' if the underlay is dynamically created.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="dynamic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dynamic must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dynamic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)""",
        })

    self.__dynamic = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dynamic(self):
    self.__dynamic = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="dynamic", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)


  def _get_committed(self):
    """
    Getter method for committed, mapped from YANG variable /networks/network/link/te/underlay/committed (boolean)

    YANG Description: 'true' if the underlay is committed.
    """
    return self.__committed
      
  def _set_committed(self, v, load=False):
    """
    Setter method for committed, mapped from YANG variable /networks/network/link/te/underlay/committed (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_committed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_committed() directly.

    YANG Description: 'true' if the underlay is committed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """committed must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)""",
        })

    self.__committed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_committed(self):
    self.__committed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)

  dynamic = __builtin__.property(_get_dynamic)
  committed = __builtin__.property(_get_committed)


  _pyangbind_elements = OrderedDict([('dynamic', dynamic), ('committed', committed), ])


