from copy import deepcopy
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID

# use "deepcopy" to prevent propagating forced changes during tests

CONTEXT_ID = {'context_uuid': {'uuid': DEFAULT_CONTEXT_UUID}}
CONTEXT = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_ids': [],
    'service_ids': [],
}

TOPOLOGY_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_uuid': {'uuid': DEFAULT_TOPOLOGY_UUID},
}
TOPOLOGY = {
    'topology_id': deepcopy(TOPOLOGY_ID),
    'device_ids': [],
    'link_ids': [],
}
