# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import vlan_pop
from . import vlan_push
class supported_vlan_operations(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-svc/supported-vlan-operations. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reports the VLAN operations supported by the ETH LTP.
  """
  __slots__ = ('_path_helper', '_extmethods', '__asymmetrical_operations','__transparent_vlan_operations','__vlan_pop','__vlan_push',)

  _yang_name = 'supported-vlan-operations'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__asymmetrical_operations = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="asymmetrical-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    self.__transparent_vlan_operations = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="transparent-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    self.__vlan_pop = YANGDynClass(base=vlan_pop.vlan_pop, is_container='container', yang_name="vlan-pop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    self.__vlan_push = YANGDynClass(base=vlan_push.vlan_push, is_container='container', yang_name="vlan-push", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-svc', 'supported-vlan-operations']

  def _get_asymmetrical_operations(self):
    """
    Getter method for asymmetrical_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/asymmetrical_operations (boolean)

    YANG Description: Indicates whether the ETH LTP supports also asymmetrical
VLAN operations.It is assumed that symmetrical VLAN
operations are alwyas supported.
    """
    return self.__asymmetrical_operations
      
  def _set_asymmetrical_operations(self, v, load=False):
    """
    Setter method for asymmetrical_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/asymmetrical_operations (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_asymmetrical_operations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_asymmetrical_operations() directly.

    YANG Description: Indicates whether the ETH LTP supports also asymmetrical
VLAN operations.It is assumed that symmetrical VLAN
operations are alwyas supported.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="asymmetrical-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """asymmetrical_operations must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="asymmetrical-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__asymmetrical_operations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_asymmetrical_operations(self):
    self.__asymmetrical_operations = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="asymmetrical-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)


  def _get_transparent_vlan_operations(self):
    """
    Getter method for transparent_vlan_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/transparent_vlan_operations (boolean)

    YANG Description: Indicates that the ETH LTP supports transparent
operations.
    """
    return self.__transparent_vlan_operations
      
  def _set_transparent_vlan_operations(self, v, load=False):
    """
    Setter method for transparent_vlan_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/transparent_vlan_operations (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transparent_vlan_operations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transparent_vlan_operations() directly.

    YANG Description: Indicates that the ETH LTP supports transparent
operations.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="transparent-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transparent_vlan_operations must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="transparent-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__transparent_vlan_operations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transparent_vlan_operations(self):
    self.__transparent_vlan_operations = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="transparent-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)


  def _get_vlan_pop(self):
    """
    Getter method for vlan_pop, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_pop (container)

    YANG Description: Indicates VLAN pop or swap operations capabilities.
    """
    return self.__vlan_pop
      
  def _set_vlan_pop(self, v, load=False):
    """
    Setter method for vlan_pop, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_pop (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_pop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_pop() directly.

    YANG Description: Indicates VLAN pop or swap operations capabilities.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=vlan_pop.vlan_pop, is_container='container', yang_name="vlan-pop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_pop must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=vlan_pop.vlan_pop, is_container='container', yang_name="vlan-pop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__vlan_pop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_pop(self):
    self.__vlan_pop = YANGDynClass(base=vlan_pop.vlan_pop, is_container='container', yang_name="vlan-pop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)


  def _get_vlan_push(self):
    """
    Getter method for vlan_push, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push (container)

    YANG Description: Indicates VLAN push or swap operations capabilities.
    """
    return self.__vlan_push
      
  def _set_vlan_push(self, v, load=False):
    """
    Setter method for vlan_push, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_push is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_push() directly.

    YANG Description: Indicates VLAN push or swap operations capabilities.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=vlan_push.vlan_push, is_container='container', yang_name="vlan-push", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_push must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=vlan_push.vlan_push, is_container='container', yang_name="vlan-push", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__vlan_push = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_push(self):
    self.__vlan_push = YANGDynClass(base=vlan_push.vlan_push, is_container='container', yang_name="vlan-push", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

  asymmetrical_operations = __builtin__.property(_get_asymmetrical_operations, _set_asymmetrical_operations)
  transparent_vlan_operations = __builtin__.property(_get_transparent_vlan_operations, _set_transparent_vlan_operations)
  vlan_pop = __builtin__.property(_get_vlan_pop, _set_vlan_pop)
  vlan_push = __builtin__.property(_get_vlan_push, _set_vlan_push)


  _pyangbind_elements = OrderedDict([('asymmetrical_operations', asymmetrical_operations), ('transparent_vlan_operations', transparent_vlan_operations), ('vlan_pop', vlan_pop), ('vlan_push', vlan_push), ])


