import xml.dom.minidom, xmltodict

def xml_pretty_print(data : str):
    return xml.dom.minidom.parseString(data).toprettyxml()

def xml_to_file(data : str, file_path : str) -> None:
    with open(file_path, mode='w', encoding='UTF-8') as f:
        f.write(xml_pretty_print(data))

def xml_to_dict(data : str):
    return xmltodict.parse(data)
