/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.DayClose;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.InstantArithmetic;

class BasicInstantArithmetic
implements InstantArithmetic {
    private final DayClose dayClose;

    BasicInstantArithmetic(DayClose dayClose) {
        if (dayClose == null) {
            throw new IllegalArgumentException();
        }
        this.dayClose = dayClose;
    }

    public Instant add(Instant instant, Duration duration) {
        Instant instant2 = instant;
        long l = duration.getMinutes();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        for (long i = 0L; i < l; i += 86400L) {
            instant2 = instant2.next(this.dayClose);
        }
        return instant2;
    }

    public Instant sub(Instant instant, Duration duration) {
        Instant instant2 = instant;
        long l = duration.getMinutes();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        for (long i = 0L; i < l; i += 86400L) {
            instant2 = instant2.prev(this.dayClose);
        }
        return instant2;
    }

    public Duration diff(Instant instant, Instant instant2) {
        if (instant2.compareTo(instant) < 0) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        while (instant2.compareTo(instant) > 0) {
            l += 86400L;
            instant = instant.next(null);
        }
        return new Duration(l);
    }
}

