/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import org.stathissideris.ascii2image.graphics.DiagramComponent;
import org.stathissideris.ascii2image.graphics.FontMeasurer;

public class DiagramText
extends DiagramComponent {
    public static final Color DEFAULT_COLOR = Color.black;
    private String text;
    private Font font;
    private int xPos;
    private int yPos;
    private Color color = Color.black;
    private boolean isTextOnLine = false;
    private boolean hasOutline = false;
    private Color outlineColor = Color.white;

    public DiagramText(int n, int n2, String string, Font font) {
        if (string == null) {
            throw new IllegalArgumentException("DiagramText cannot be initialised with a null string");
        }
        if (font == null) {
            throw new IllegalArgumentException("DiagramText cannot be initialised with a null font");
        }
        this.xPos = n;
        this.yPos = n2;
        this.text = string;
        this.font = font;
    }

    public void centerInBounds(Rectangle2D rectangle2D) {
        this.centerHorizontallyBetween((int)rectangle2D.getMinX(), (int)rectangle2D.getMaxX());
        this.centerVerticallyBetween((int)rectangle2D.getMinY(), (int)rectangle2D.getMaxY());
    }

    public void centerHorizontallyBetween(int n, int n2) {
        int n3 = FontMeasurer.instance().getWidthFor(this.text, this.font);
        int n4 = Math.abs(n2 - n) / 2;
        this.xPos += Math.abs(n4 - n3 / 2);
    }

    public void centerVerticallyBetween(int n, int n2) {
        int n3 = FontMeasurer.instance().getZHeight(this.font);
        int n4 = Math.abs(n2 - n) / 2;
        this.yPos -= Math.abs(n4 - n3 / 2);
    }

    public void alignRightEdgeTo(int n) {
        int n2 = FontMeasurer.instance().getWidthFor(this.text, this.font);
        this.xPos = n - n2;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setXPos(int n) {
        this.xPos = n;
    }

    public void setYPos(int n) {
        this.yPos = n;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = FontMeasurer.instance().getBoundsFor(this.text, this.font);
        rectangle2D.setRect(rectangle2D.getMinX() + (double)this.xPos, rectangle2D.getMinY() + (double)this.yPos, rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    public String toString() {
        return "DiagramText, at (" + this.xPos + ", " + this.yPos + "), within " + this.getBounds() + " '" + this.text + "', " + this.color + " " + this.font;
    }

    public boolean isTextOnLine() {
        return this.isTextOnLine;
    }

    public void setTextOnLine(boolean bl) {
        this.isTextOnLine = bl;
    }

    public boolean hasOutline() {
        return this.hasOutline;
    }

    public void setHasOutline(boolean bl) {
        this.hasOutline = bl;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }
}

