from __future__ import annotations
from typing import Union
from common.type_checkers.Checkers import chk_boolean
from .Field import Field

BOOL_TRUE_VALUES = {'TRUE', 'T', '1'}

class BooleanField(Field):
    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, type_=bool, **kwargs)

    def validate(self, value : Union[bool, str], try_convert_type=False) -> bool:
        value = self.is_required(value)
        if value is None: return None
        if try_convert_type and isinstance(value, str):
            return value.upper() in BOOL_TRUE_VALUES
        return chk_boolean(self.name, value)
