# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_interfaces__interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the global, physical interface
level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__mtu','__loopback_mode','__description','__enabled',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/config/name (string)

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /interfaces/interface/config/type (identityref)

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /interfaces/interface/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-interfaces:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)


  def _get_mtu(self):
    """
    Getter method for mtu, mapped from YANG variable /interfaces/interface/config/mtu (uint16)

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    return self.__mtu
      
  def _set_mtu(self, v, load=False):
    """
    Setter method for mtu, mapped from YANG variable /interfaces/interface/config/mtu (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mtu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mtu() directly.

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mtu must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)""",
        })

    self.__mtu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mtu(self):
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /interfaces/interface/config/loopback_mode (boolean)

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /interfaces/interface/config/loopback_mode (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/config/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  mtu = __builtin__.property(_get_mtu, _set_mtu)
  loopback_mode = __builtin__.property(_get_loopback_mode, _set_loopback_mode)
  description = __builtin__.property(_get_description, _set_description)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('mtu', mtu), ('loopback_mode', loopback_mode), ('description', description), ('enabled', enabled), ])


class yc_counters_openconfig_interfaces__interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of interface-related statistics objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__in_unicast_pkts','__in_broadcast_pkts','__in_multicast_pkts','__in_discards','__in_errors','__in_unknown_protos','__in_fcs_errors','__out_octets','__out_pkts','__out_unicast_pkts','__out_broadcast_pkts','__out_multicast_pkts','__out_discards','__out_errors','__carrier_transitions','__last_clear',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /interfaces/interface/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /interfaces/interface/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unicast_pkts(self):
    """
    Getter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_unicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unicast_pkts
      
  def _set_in_unicast_pkts(self, v, load=False):
    """
    Setter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unicast_pkts(self):
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_broadcast_pkts(self):
    """
    Getter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_broadcast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_broadcast_pkts
      
  def _set_in_broadcast_pkts(self, v, load=False):
    """
    Setter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_broadcast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_broadcast_pkts(self):
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_multicast_pkts(self):
    """
    Getter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_multicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_multicast_pkts
      
  def _set_in_multicast_pkts(self, v, load=False):
    """
    Setter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/in_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_multicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_multicast_pkts(self):
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_discards(self):
    """
    Getter method for in_discards, mapped from YANG variable /interfaces/interface/state/counters/in_discards (oc-yang:counter64)

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_discards
      
  def _set_in_discards(self, v, load=False):
    """
    Setter method for in_discards, mapped from YANG variable /interfaces/interface/state/counters/in_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_discards() directly.

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_discards(self):
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_errors(self):
    """
    Getter method for in_errors, mapped from YANG variable /interfaces/interface/state/counters/in_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_errors
      
  def _set_in_errors(self, v, load=False):
    """
    Setter method for in_errors, mapped from YANG variable /interfaces/interface/state/counters/in_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_errors(self):
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unknown_protos(self):
    """
    Getter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/state/counters/in_unknown_protos (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unknown_protos
      
  def _set_in_unknown_protos(self, v, load=False):
    """
    Setter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/state/counters/in_unknown_protos (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unknown_protos is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unknown_protos() directly.

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unknown_protos must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unknown_protos = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unknown_protos(self):
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fcs_errors(self):
    """
    Getter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/state/counters/in_fcs_errors (oc-yang:counter64)

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    return self.__in_fcs_errors
      
  def _set_in_fcs_errors(self, v, load=False):
    """
    Setter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/state/counters/in_fcs_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fcs_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fcs_errors() directly.

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fcs_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fcs_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fcs_errors(self):
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /interfaces/interface/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /interfaces/interface/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_unicast_pkts(self):
    """
    Getter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_unicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_unicast_pkts
      
  def _set_out_unicast_pkts(self, v, load=False):
    """
    Setter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_unicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_unicast_pkts(self):
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_broadcast_pkts(self):
    """
    Getter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_broadcast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_broadcast_pkts
      
  def _set_out_broadcast_pkts(self, v, load=False):
    """
    Setter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_broadcast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_broadcast_pkts(self):
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_multicast_pkts(self):
    """
    Getter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_multicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_multicast_pkts
      
  def _set_out_multicast_pkts(self, v, load=False):
    """
    Setter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/state/counters/out_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_multicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_multicast_pkts(self):
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_discards(self):
    """
    Getter method for out_discards, mapped from YANG variable /interfaces/interface/state/counters/out_discards (oc-yang:counter64)

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_discards
      
  def _set_out_discards(self, v, load=False):
    """
    Setter method for out_discards, mapped from YANG variable /interfaces/interface/state/counters/out_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_discards() directly.

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_discards(self):
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_errors(self):
    """
    Getter method for out_errors, mapped from YANG variable /interfaces/interface/state/counters/out_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_errors
      
  def _set_out_errors(self, v, load=False):
    """
    Setter method for out_errors, mapped from YANG variable /interfaces/interface/state/counters/out_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_errors(self):
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_carrier_transitions(self):
    """
    Getter method for carrier_transitions, mapped from YANG variable /interfaces/interface/state/counters/carrier_transitions (oc-yang:counter64)

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    return self.__carrier_transitions
      
  def _set_carrier_transitions(self, v, load=False):
    """
    Setter method for carrier_transitions, mapped from YANG variable /interfaces/interface/state/counters/carrier_transitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_carrier_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_carrier_transitions() directly.

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """carrier_transitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__carrier_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_carrier_transitions(self):
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /interfaces/interface/state/counters/last_clear (oc-types:timeticks64)

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /interfaces/interface/state/counters/last_clear (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  in_unicast_pkts = __builtin__.property(_get_in_unicast_pkts)
  in_broadcast_pkts = __builtin__.property(_get_in_broadcast_pkts)
  in_multicast_pkts = __builtin__.property(_get_in_multicast_pkts)
  in_discards = __builtin__.property(_get_in_discards)
  in_errors = __builtin__.property(_get_in_errors)
  in_unknown_protos = __builtin__.property(_get_in_unknown_protos)
  in_fcs_errors = __builtin__.property(_get_in_fcs_errors)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)
  out_unicast_pkts = __builtin__.property(_get_out_unicast_pkts)
  out_broadcast_pkts = __builtin__.property(_get_out_broadcast_pkts)
  out_multicast_pkts = __builtin__.property(_get_out_multicast_pkts)
  out_discards = __builtin__.property(_get_out_discards)
  out_errors = __builtin__.property(_get_out_errors)
  carrier_transitions = __builtin__.property(_get_carrier_transitions)
  last_clear = __builtin__.property(_get_last_clear)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('in_unicast_pkts', in_unicast_pkts), ('in_broadcast_pkts', in_broadcast_pkts), ('in_multicast_pkts', in_multicast_pkts), ('in_discards', in_discards), ('in_errors', in_errors), ('in_unknown_protos', in_unknown_protos), ('in_fcs_errors', in_fcs_errors), ('out_octets', out_octets), ('out_pkts', out_pkts), ('out_unicast_pkts', out_unicast_pkts), ('out_broadcast_pkts', out_broadcast_pkts), ('out_multicast_pkts', out_multicast_pkts), ('out_discards', out_discards), ('out_errors', out_errors), ('carrier_transitions', carrier_transitions), ('last_clear', last_clear), ])


class yc_state_openconfig_interfaces__interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data at the global interface level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__mtu','__loopback_mode','__description','__enabled','__ifindex','__admin_status','__oper_status','__last_change','__logical','__management','__cpu','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/state/name (string)

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /interfaces/interface/state/type (identityref)

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /interfaces/interface/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-interfaces:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=False)


  def _get_mtu(self):
    """
    Getter method for mtu, mapped from YANG variable /interfaces/interface/state/mtu (uint16)

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    return self.__mtu
      
  def _set_mtu(self, v, load=False):
    """
    Setter method for mtu, mapped from YANG variable /interfaces/interface/state/mtu (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mtu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mtu() directly.

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mtu must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)""",
        })

    self.__mtu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mtu(self):
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=False)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /interfaces/interface/state/loopback_mode (boolean)

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /interfaces/interface/state/loopback_mode (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/state/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_ifindex(self):
    """
    Getter method for ifindex, mapped from YANG variable /interfaces/interface/state/ifindex (uint32)

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    return self.__ifindex
      
  def _set_ifindex(self, v, load=False):
    """
    Setter method for ifindex, mapped from YANG variable /interfaces/interface/state/ifindex (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ifindex is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ifindex() directly.

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ifindex must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__ifindex = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ifindex(self):
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_admin_status(self):
    """
    Getter method for admin_status, mapped from YANG variable /interfaces/interface/state/admin_status (enumeration)

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    return self.__admin_status
      
  def _set_admin_status(self, v, load=False):
    """
    Setter method for admin_status, mapped from YANG variable /interfaces/interface/state/admin_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_status() directly.

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__admin_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_status(self):
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /interfaces/interface/state/oper_status (enumeration)

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /interfaces/interface/state/oper_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_last_change(self):
    """
    Getter method for last_change, mapped from YANG variable /interfaces/interface/state/last_change (oc-types:timeticks64)

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_change
      
  def _set_last_change(self, v, load=False):
    """
    Setter method for last_change, mapped from YANG variable /interfaces/interface/state/last_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_change() directly.

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_change(self):
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)


  def _get_logical(self):
    """
    Getter method for logical, mapped from YANG variable /interfaces/interface/state/logical (boolean)

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    return self.__logical
      
  def _set_logical(self, v, load=False):
    """
    Setter method for logical, mapped from YANG variable /interfaces/interface/state/logical (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical() directly.

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__logical = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical(self):
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_management(self):
    """
    Getter method for management, mapped from YANG variable /interfaces/interface/state/management (boolean)

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    return self.__management
      
  def _set_management(self, v, load=False):
    """
    Setter method for management, mapped from YANG variable /interfaces/interface/state/management (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management() directly.

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__management = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management(self):
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_cpu(self):
    """
    Getter method for cpu, mapped from YANG variable /interfaces/interface/state/cpu (boolean)

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    return self.__cpu
      
  def _set_cpu(self, v, load=False):
    """
    Setter method for cpu, mapped from YANG variable /interfaces/interface/state/cpu (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu() directly.

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__cpu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu(self):
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /interfaces/interface/state/counters (container)

    YANG Description: A collection of interface-related statistics objects.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: A collection of interface-related statistics objects.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  mtu = __builtin__.property(_get_mtu)
  loopback_mode = __builtin__.property(_get_loopback_mode)
  description = __builtin__.property(_get_description)
  enabled = __builtin__.property(_get_enabled)
  ifindex = __builtin__.property(_get_ifindex)
  admin_status = __builtin__.property(_get_admin_status)
  oper_status = __builtin__.property(_get_oper_status)
  last_change = __builtin__.property(_get_last_change)
  logical = __builtin__.property(_get_logical)
  management = __builtin__.property(_get_management)
  cpu = __builtin__.property(_get_cpu)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('mtu', mtu), ('loopback_mode', loopback_mode), ('description', description), ('enabled', enabled), ('ifindex', ifindex), ('admin_status', admin_status), ('oper_status', oper_status), ('last_change', last_change), ('logical', logical), ('management', management), ('cpu', cpu), ('counters', counters), ])


class yc_config_openconfig_interfaces__interfaces_interface_hold_time_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/hold-time/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for interface hold-time settings.
  """
  __slots__ = ('_path_helper', '_extmethods', '__up','__down',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'hold-time', 'config']

  def _get_up(self):
    """
    Getter method for up, mapped from YANG variable /interfaces/interface/hold_time/config/up (uint32)

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    return self.__up
      
  def _set_up(self, v, load=False):
    """
    Setter method for up, mapped from YANG variable /interfaces/interface/hold_time/config/up (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up() directly.

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)""",
        })

    self.__up = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up(self):
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)


  def _get_down(self):
    """
    Getter method for down, mapped from YANG variable /interfaces/interface/hold_time/config/down (uint32)

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    return self.__down
      
  def _set_down(self, v, load=False):
    """
    Setter method for down, mapped from YANG variable /interfaces/interface/hold_time/config/down (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_down is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_down() directly.

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """down must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)""",
        })

    self.__down = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_down(self):
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)

  up = __builtin__.property(_get_up, _set_up)
  down = __builtin__.property(_get_down, _set_down)


  _pyangbind_elements = OrderedDict([('up', up), ('down', down), ])


class yc_state_openconfig_interfaces__interfaces_interface_hold_time_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/hold-time/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for interface hold-time.
  """
  __slots__ = ('_path_helper', '_extmethods', '__up','__down',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'hold-time', 'state']

  def _get_up(self):
    """
    Getter method for up, mapped from YANG variable /interfaces/interface/hold_time/state/up (uint32)

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    return self.__up
      
  def _set_up(self, v, load=False):
    """
    Setter method for up, mapped from YANG variable /interfaces/interface/hold_time/state/up (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up() directly.

    YANG Description: Dampens advertisement when the interface
transitions from down to up.  A zero value means dampening
is turned off, i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__up = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up(self):
    self.__up = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="up", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_down(self):
    """
    Getter method for down, mapped from YANG variable /interfaces/interface/hold_time/state/down (uint32)

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    return self.__down
      
  def _set_down(self, v, load=False):
    """
    Setter method for down, mapped from YANG variable /interfaces/interface/hold_time/state/down (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_down is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_down() directly.

    YANG Description: Dampens advertisement when the interface transitions from
up to down.  A zero value means dampening is turned off,
i.e., immediate notification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """down must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__down = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_down(self):
    self.__down = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="down", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)

  up = __builtin__.property(_get_up)
  down = __builtin__.property(_get_down)


  _pyangbind_elements = OrderedDict([('up', up), ('down', down), ])


class yc_hold_time_openconfig_interfaces__interfaces_interface_hold_time(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/hold-time. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for hold-time settings to enable
dampening advertisements of interface transitions.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'hold-time'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'hold-time']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/hold_time/config (container)

    YANG Description: Configuration data for interface hold-time settings.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/hold_time/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for interface hold-time settings.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_hold_time_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/hold_time/state (container)

    YANG Description: Operational state data for interface hold-time.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/hold_time/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for interface hold-time.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_hold_time_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the subinterface level
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__enabled',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/index (uint32)

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  description = __builtin__.property(_get_description, _set_description)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('enabled', enabled), ])


class yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A collection of interface-related statistics objects.
  """
  __slots__ = ('_path_helper', '_extmethods', '__in_octets','__in_pkts','__in_unicast_pkts','__in_broadcast_pkts','__in_multicast_pkts','__in_discards','__in_errors','__in_unknown_protos','__in_fcs_errors','__out_octets','__out_pkts','__out_unicast_pkts','__out_broadcast_pkts','__out_multicast_pkts','__out_discards','__out_errors','__carrier_transitions','__last_clear',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'state', 'counters']

  def _get_in_octets(self):
    """
    Getter method for in_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_octets (oc-yang:counter64)

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_octets
      
  def _set_in_octets(self, v, load=False):
    """
    Setter method for in_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_octets() directly.

    YANG Description: The total number of octets received on the interface,
including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_octets(self):
    self.__in_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pkts(self):
    """
    Getter method for in_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_pkts (oc-yang:counter64)

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    return self.__in_pkts
      
  def _set_in_pkts(self, v, load=False):
    """
    Setter method for in_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pkts() directly.

    YANG Description: The total number of packets received on the interface,
including all unicast, multicast, broadcast and bad packets
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pkts(self):
    self.__in_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unicast_pkts(self):
    """
    Getter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unicast_pkts
      
  def _set_in_unicast_pkts(self, v, load=False):
    """
    Setter method for in_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were not addressed to a
multicast or broadcast address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unicast_pkts(self):
    self.__in_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_broadcast_pkts(self):
    """
    Getter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_broadcast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_broadcast_pkts
      
  def _set_in_broadcast_pkts(self, v, load=False):
    """
    Setter method for in_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_broadcast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a broadcast
address at this sub-layer.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_broadcast_pkts(self):
    self.__in_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_multicast_pkts(self):
    """
    Getter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_multicast_pkts (oc-yang:counter64)

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_multicast_pkts
      
  def _set_in_multicast_pkts(self, v, load=False):
    """
    Setter method for in_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_multicast_pkts() directly.

    YANG Description: The number of packets, delivered by this sub-layer to a
higher (sub-)layer, that were addressed to a multicast
address at this sub-layer.  For a MAC-layer protocol,
this includes both Group and Functional addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_multicast_pkts(self):
    self.__in_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_discards(self):
    """
    Getter method for in_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_discards (oc-yang:counter64)

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_discards
      
  def _set_in_discards(self, v, load=False):
    """
    Setter method for in_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_discards() directly.

    YANG Description: The number of inbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being deliverable to a higher-layer
protocol.  One possible reason for discarding such a
packet could be to free up buffer space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_discards(self):
    self.__in_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_errors(self):
    """
    Getter method for in_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_errors
      
  def _set_in_errors(self, v, load=False):
    """
    Setter method for in_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of inbound
packets that contained errors preventing them from being
deliverable to a higher-layer protocol.  For character-
oriented or fixed-length interfaces, the number of
inbound transmission units that contained errors
preventing them from being deliverable to a higher-layer
protocol.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_errors(self):
    self.__in_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_unknown_protos(self):
    """
    Getter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unknown_protos (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__in_unknown_protos
      
  def _set_in_unknown_protos(self, v, load=False):
    """
    Setter method for in_unknown_protos, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_unknown_protos (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_unknown_protos is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_unknown_protos() directly.

    YANG Description: For packet-oriented interfaces, the number of packets
received via the interface that were discarded because
of an unknown or unsupported protocol.  For
character-oriented or fixed-length interfaces that
support protocol multiplexing, the number of
transmission units received via the interface that were
discarded because of an unknown or unsupported protocol.
For any interface that does not support protocol
multiplexing, this counter is not present.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_unknown_protos must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_unknown_protos = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_unknown_protos(self):
    self.__in_unknown_protos = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-unknown-protos", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fcs_errors(self):
    """
    Getter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_fcs_errors (oc-yang:counter64)

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    return self.__in_fcs_errors
      
  def _set_in_fcs_errors(self, v, load=False):
    """
    Setter method for in_fcs_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/in_fcs_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fcs_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fcs_errors() directly.

    YANG Description: Number of received packets which had errors in the
frame check sequence (FCS), i.e., framing errors.

Discontinuities in the value of this counter can occur
when the device is re-initialization as indicated by the
value of 'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fcs_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fcs_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fcs_errors(self):
    self.__in_fcs_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fcs-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_octets(self):
    """
    Getter method for out_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_octets (oc-yang:counter64)

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_octets
      
  def _set_out_octets(self, v, load=False):
    """
    Setter method for out_octets, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_octets() directly.

    YANG Description: The total number of octets transmitted out of the
interface, including framing characters.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_octets(self):
    self.__out_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pkts(self):
    """
    Getter method for out_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_pkts (oc-yang:counter64)

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    return self.__out_pkts
      
  def _set_out_pkts(self, v, load=False):
    """
    Setter method for out_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pkts() directly.

    YANG Description: The total number of packets transmitted out of the
interface, including all unicast, multicast, broadcast,
and bad packets etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pkts(self):
    self.__out_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_unicast_pkts(self):
    """
    Getter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_unicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_unicast_pkts
      
  def _set_out_unicast_pkts(self, v, load=False):
    """
    Setter method for out_unicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_unicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_unicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_unicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were not addressed
to a multicast or broadcast address at this sub-layer,
including those that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_unicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_unicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_unicast_pkts(self):
    self.__out_unicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-unicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_broadcast_pkts(self):
    """
    Getter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_broadcast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_broadcast_pkts
      
  def _set_out_broadcast_pkts(self, v, load=False):
    """
    Setter method for out_broadcast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_broadcast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_broadcast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_broadcast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
broadcast address at this sub-layer, including those
that were discarded or not sent.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_broadcast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_broadcast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_broadcast_pkts(self):
    self.__out_broadcast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-broadcast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_multicast_pkts(self):
    """
    Getter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_multicast_pkts (oc-yang:counter64)

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_multicast_pkts
      
  def _set_out_multicast_pkts(self, v, load=False):
    """
    Setter method for out_multicast_pkts, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_multicast_pkts (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_multicast_pkts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_multicast_pkts() directly.

    YANG Description: The total number of packets that higher-level protocols
requested be transmitted, and that were addressed to a
multicast address at this sub-layer, including those
that were discarded or not sent.  For a MAC-layer
protocol, this includes both Group and Functional
addresses.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_multicast_pkts must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_multicast_pkts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_multicast_pkts(self):
    self.__out_multicast_pkts = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-multicast-pkts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_discards(self):
    """
    Getter method for out_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_discards (oc-yang:counter64)

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_discards
      
  def _set_out_discards(self, v, load=False):
    """
    Setter method for out_discards, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_discards (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_discards is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_discards() directly.

    YANG Description: The number of outbound packets that were chosen to be
discarded even though no errors had been detected to
prevent their being transmitted.  One possible reason
for discarding such a packet could be to free up buffer
space.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_discards must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_discards = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_discards(self):
    self.__out_discards = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-discards", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_errors(self):
    """
    Getter method for out_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_errors (oc-yang:counter64)

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    return self.__out_errors
      
  def _set_out_errors(self, v, load=False):
    """
    Setter method for out_errors, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/out_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_errors() directly.

    YANG Description: For packet-oriented interfaces, the number of outbound
packets that could not be transmitted because of errors.
For character-oriented or fixed-length interfaces, the
number of outbound transmission units that could not be
transmitted because of errors.

Discontinuities in the value of this counter can occur
at re-initialization of the management system, and at
other times as indicated by the value of
'last-clear'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_errors(self):
    self.__out_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_carrier_transitions(self):
    """
    Getter method for carrier_transitions, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/carrier_transitions (oc-yang:counter64)

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    return self.__carrier_transitions
      
  def _set_carrier_transitions(self, v, load=False):
    """
    Setter method for carrier_transitions, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/carrier_transitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_carrier_transitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_carrier_transitions() directly.

    YANG Description: Number of times the interface state has transitioned
between up and down since the time the device restarted
or the last-clear time, whichever is most recent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """carrier_transitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__carrier_transitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_carrier_transitions(self):
    self.__carrier_transitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="carrier-transitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/last_clear (oc-types:timeticks64)

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters/last_clear (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Timestamp of the last time the interface counters were
cleared.

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)

  in_octets = __builtin__.property(_get_in_octets)
  in_pkts = __builtin__.property(_get_in_pkts)
  in_unicast_pkts = __builtin__.property(_get_in_unicast_pkts)
  in_broadcast_pkts = __builtin__.property(_get_in_broadcast_pkts)
  in_multicast_pkts = __builtin__.property(_get_in_multicast_pkts)
  in_discards = __builtin__.property(_get_in_discards)
  in_errors = __builtin__.property(_get_in_errors)
  in_unknown_protos = __builtin__.property(_get_in_unknown_protos)
  in_fcs_errors = __builtin__.property(_get_in_fcs_errors)
  out_octets = __builtin__.property(_get_out_octets)
  out_pkts = __builtin__.property(_get_out_pkts)
  out_unicast_pkts = __builtin__.property(_get_out_unicast_pkts)
  out_broadcast_pkts = __builtin__.property(_get_out_broadcast_pkts)
  out_multicast_pkts = __builtin__.property(_get_out_multicast_pkts)
  out_discards = __builtin__.property(_get_out_discards)
  out_errors = __builtin__.property(_get_out_errors)
  carrier_transitions = __builtin__.property(_get_carrier_transitions)
  last_clear = __builtin__.property(_get_last_clear)


  _pyangbind_elements = OrderedDict([('in_octets', in_octets), ('in_pkts', in_pkts), ('in_unicast_pkts', in_unicast_pkts), ('in_broadcast_pkts', in_broadcast_pkts), ('in_multicast_pkts', in_multicast_pkts), ('in_discards', in_discards), ('in_errors', in_errors), ('in_unknown_protos', in_unknown_protos), ('in_fcs_errors', in_fcs_errors), ('out_octets', out_octets), ('out_pkts', out_pkts), ('out_unicast_pkts', out_unicast_pkts), ('out_broadcast_pkts', out_broadcast_pkts), ('out_multicast_pkts', out_multicast_pkts), ('out_discards', out_discards), ('out_errors', out_errors), ('carrier_transitions', carrier_transitions), ('last_clear', last_clear), ])


class yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for logical interfaces
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__enabled','__name','__ifindex','__admin_status','__oper_status','__last_change','__logical','__management','__cpu','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/index (uint32)

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: The index of the subinterface, or logical interface number.
On systems with no support for subinterfaces, or not using
subinterfaces, this value should default to 0, i.e., the
default subinterface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/name (string)

    YANG Description: The system-assigned name for the sub-interface.  This MAY
be a combination of the base interface name and the
subinterface index, or some other convention used by the
system.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The system-assigned name for the sub-interface.  This MAY
be a combination of the base interface name and the
subinterface index, or some other convention used by the
system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=False)


  def _get_ifindex(self):
    """
    Getter method for ifindex, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/ifindex (uint32)

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    return self.__ifindex
      
  def _set_ifindex(self, v, load=False):
    """
    Setter method for ifindex, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/ifindex (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ifindex is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ifindex() directly.

    YANG Description: System assigned number for each interface.  Corresponds to
ifIndex object in SNMP Interface MIB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ifindex must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)""",
        })

    self.__ifindex = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ifindex(self):
    self.__ifindex = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="ifindex", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint32', is_config=False)


  def _get_admin_status(self):
    """
    Getter method for admin_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/admin_status (enumeration)

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    return self.__admin_status
      
  def _set_admin_status(self, v, load=False):
    """
    Setter method for admin_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/admin_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_status() directly.

    YANG Description: The desired state of the interface.  In RFC 7223 this leaf
has the same read semantics as ifAdminStatus.  Here, it
reflects the administrative state as set by enabling or
disabling the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__admin_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_status(self):
    self.__admin_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="admin-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/oper_status (enumeration)

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/oper_status (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: The current operational state of the interface.

This leaf has the same semantics as ifOperStatus.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with enumeration""",
          'defined-type': "openconfig-interfaces:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {'value': 1}, 'DOWN': {'value': 2}, 'TESTING': {'value': 3}, 'UNKNOWN': {'value': 4}, 'DORMANT': {'value': 5}, 'NOT_PRESENT': {'value': 6}, 'LOWER_LAYER_DOWN': {'value': 7}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='enumeration', is_config=False)


  def _get_last_change(self):
    """
    Getter method for last_change, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/last_change (oc-types:timeticks64)

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__last_change
      
  def _set_last_change(self, v, load=False):
    """
    Setter method for last_change, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/last_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_change() directly.

    YANG Description: This timestamp indicates the absolute time of the last
state change of the interface (e.g., up-to-down transition).
This is different than the SNMP ifLastChange object in the
standard interface MIB in that it is not relative to the
system boot time (i.e,. sysUpTime).

The value is the timestamp in nanoseconds relative to
the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_change(self):
    self.__last_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='oc-types:timeticks64', is_config=False)


  def _get_logical(self):
    """
    Getter method for logical, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/logical (boolean)

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    return self.__logical
      
  def _set_logical(self, v, load=False):
    """
    Setter method for logical, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/logical (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical() directly.

    YANG Description: When set to true, the interface is a logical interface
which does not have an associated physical port or
channel on the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__logical = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical(self):
    self.__logical = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="logical", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_management(self):
    """
    Getter method for management, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/management (boolean)

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    return self.__management
      
  def _set_management(self, v, load=False):
    """
    Setter method for management, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/management (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management() directly.

    YANG Description: When set to true, the interface is a dedicated
management interface that is not connected to dataplane
interfaces.  It may be used to connect the system to an
out-of-band management network, for example.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__management = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management(self):
    self.__management = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="management", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_cpu(self):
    """
    Getter method for cpu, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/cpu (boolean)

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    return self.__cpu
      
  def _set_cpu(self, v, load=False):
    """
    Setter method for cpu, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/cpu (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu() directly.

    YANG Description: When set to true, the interface is for traffic
that is handled by the system CPU, sometimes also called the
control plane interface.  On systems that represent the CPU
interface as an Ethernet interface, for example, this leaf
should be used to distinguish the CPU interface from dataplane
interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)""",
        })

    self.__cpu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu(self):
    self.__cpu = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters (container)

    YANG Description: A collection of interface-related statistics objects.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: A collection of interface-related statistics objects.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=False)

  index = __builtin__.property(_get_index)
  description = __builtin__.property(_get_description)
  enabled = __builtin__.property(_get_enabled)
  name = __builtin__.property(_get_name)
  ifindex = __builtin__.property(_get_ifindex)
  admin_status = __builtin__.property(_get_admin_status)
  oper_status = __builtin__.property(_get_oper_status)
  last_change = __builtin__.property(_get_last_change)
  logical = __builtin__.property(_get_logical)
  management = __builtin__.property(_get_management)
  cpu = __builtin__.property(_get_cpu)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('enabled', enabled), ('name', name), ('ifindex', ifindex), ('admin_status', admin_status), ('oper_status', oper_status), ('last_change', last_change), ('logical', logical), ('management', management), ('cpu', cpu), ('counters', counters), ])


class yc_subinterface_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces/subinterface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The list of subinterfaces (logical interfaces) associated
with a physical interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__config','__state',)

  _yang_name = 'subinterface'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces', 'subinterface']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/index (leafref)

    YANG Description: The index number of the subinterface -- used to address
the logical interface
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: The index number of the subinterface -- used to address
the logical interface
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config (container)

    YANG Description: Configurable items at the subinterface level
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configurable items at the subinterface level
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state (container)

    YANG Description: Operational state data for logical interfaces
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for logical interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('index', index), ('config', config), ('state', state), ])


class yc_subinterfaces_openconfig_interfaces__interfaces_interface_subinterfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/subinterfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of subinterfaces associated
with a physical interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__subinterface',)

  _yang_name = 'subinterfaces'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__subinterface = YANGDynClass(base=YANGListType("index",yc_subinterface_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface, yang_name="subinterface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'subinterfaces']

  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface (list)

    YANG Description: The list of subinterfaces (logical interfaces) associated
with a physical interface
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /interfaces/interface/subinterfaces/subinterface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: The list of subinterfaces (logical interfaces) associated
with a physical interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",yc_subinterface_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface, yang_name="subinterface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",yc_subinterface_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface, yang_name="subinterface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=YANGListType("index",yc_subinterface_openconfig_interfaces__interfaces_interface_subinterfaces_subinterface, yang_name="subinterface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)

  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('subinterface', subinterface), ])


class yc_interface_openconfig_interfaces__interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The list of named interfaces on the device.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__hold_time','__subinterfaces',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    self.__hold_time = YANGDynClass(base=yc_hold_time_openconfig_interfaces__interfaces_interface_hold_time, is_container='container', yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    self.__subinterfaces = YANGDynClass(base=yc_subinterfaces_openconfig_interfaces__interfaces_interface_subinterfaces, is_container='container', yang_name="subinterfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/name (leafref)

    YANG Description: References the name of the interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: References the name of the interface
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /interfaces/interface/config (container)

    YANG Description: Configurable items at the global, physical interface
level
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configurable items at the global, physical interface
level
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_interfaces__interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_interfaces__interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /interfaces/interface/state (container)

    YANG Description: Operational state data at the global interface level
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data at the global interface level
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_interfaces__interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_interfaces__interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)


  def _get_hold_time(self):
    """
    Getter method for hold_time, mapped from YANG variable /interfaces/interface/hold_time (container)

    YANG Description: Top-level container for hold-time settings to enable
dampening advertisements of interface transitions.
    """
    return self.__hold_time
      
  def _set_hold_time(self, v, load=False):
    """
    Setter method for hold_time, mapped from YANG variable /interfaces/interface/hold_time (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_time() directly.

    YANG Description: Top-level container for hold-time settings to enable
dampening advertisements of interface transitions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_hold_time_openconfig_interfaces__interfaces_interface_hold_time, is_container='container', yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_time must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_hold_time_openconfig_interfaces__interfaces_interface_hold_time, is_container='container', yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__hold_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_time(self):
    self.__hold_time = YANGDynClass(base=yc_hold_time_openconfig_interfaces__interfaces_interface_hold_time, is_container='container', yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)


  def _get_subinterfaces(self):
    """
    Getter method for subinterfaces, mapped from YANG variable /interfaces/interface/subinterfaces (container)

    YANG Description: Enclosing container for the list of subinterfaces associated
with a physical interface
    """
    return self.__subinterfaces
      
  def _set_subinterfaces(self, v, load=False):
    """
    Setter method for subinterfaces, mapped from YANG variable /interfaces/interface/subinterfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterfaces() directly.

    YANG Description: Enclosing container for the list of subinterfaces associated
with a physical interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_subinterfaces_openconfig_interfaces__interfaces_interface_subinterfaces, is_container='container', yang_name="subinterfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_subinterfaces_openconfig_interfaces__interfaces_interface_subinterfaces, is_container='container', yang_name="subinterfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__subinterfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterfaces(self):
    self.__subinterfaces = YANGDynClass(base=yc_subinterfaces_openconfig_interfaces__interfaces_interface_subinterfaces, is_container='container', yang_name="subinterfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  hold_time = __builtin__.property(_get_hold_time, _set_hold_time)
  subinterfaces = __builtin__.property(_get_subinterfaces, _set_subinterfaces)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('hold_time', hold_time), ('subinterfaces', subinterfaces), ])


class yc_interfaces_openconfig_interfaces__interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for interfaces, including configuration
and state data.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_interfaces__interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /interfaces/interface (list)

    YANG Description: The list of named interfaces on the device.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: The list of named interfaces on the device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_interfaces__interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_interfaces__interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_interfaces__interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class openconfig_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /openconfig-interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Model for managing network interfaces and subinterfaces.  This
module also defines convenience types / groupings for other
models to create references to interfaces:

 base-interface-ref (type) -  reference to a base interface
 interface-ref (grouping) -  container for reference to a
   interface + subinterface
 interface-ref-state (grouping) - container for read-only
   (opstate) reference to interface + subinterface

This model reuses data items defined in the IETF YANG model for
interfaces described by RFC 7223 with an alternate structure
(particularly for operational state data) and with
additional configuration items.

Portions of this code were derived from IETF RFC 7223.
Please reproduce this note if possible.

IETF code is subject to the following copyright and license:
Copyright (c) IETF Trust and the persons identified as authors of
the code.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, is permitted pursuant to, and subject to the license
terms contained in, the Simplified BSD License set forth in
Section 4.c of the IETF Trust's Legal Provisions Relating
to IETF Documents (http://trustee.ietf.org/license-info).
  """
  __slots__ = ('_path_helper', '_extmethods', '__interfaces',)

  _yang_name = 'openconfig-interfaces'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_interfaces__interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /interfaces (container)

    YANG Description: Top level container for interfaces, including configuration
and state data.
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Top level container for interfaces, including configuration
and state data.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_interfaces__interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_interfaces__interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_interfaces__interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='container', is_config=True)

  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('interfaces', interfaces), ])


