# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class topology(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/information-source-state/topology. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: When the information is processed by the system,
the attributes in this container indicate which topology
is used to generate the result information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__link_ref','__network_ref',)

  _yang_name = 'topology'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__link_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="link-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)
    self.__network_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'information-source-state', 'topology']

  def _get_link_ref(self):
    """
    Getter method for link_ref, mapped from YANG variable /networks/network/link/te/information_source_state/topology/link_ref (leafref)

    YANG Description: A type for an absolute reference to a link instance.
(This type should not be used for relative references.
In such a case, a relative path should be used instead.)
    """
    return self.__link_ref
      
  def _set_link_ref(self, v, load=False):
    """
    Setter method for link_ref, mapped from YANG variable /networks/network/link/te/information_source_state/topology/link_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_ref() directly.

    YANG Description: A type for an absolute reference to a link instance.
(This type should not be used for relative references.
In such a case, a relative path should be used instead.)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="link-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="link-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)""",
        })

    self.__link_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_ref(self):
    self.__link_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="link-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)


  def _get_network_ref(self):
    """
    Getter method for network_ref, mapped from YANG variable /networks/network/link/te/information_source_state/topology/network_ref (leafref)

    YANG Description: Used to reference a network -- for example, an underlay
network.
    """
    return self.__network_ref
      
  def _set_network_ref(self, v, load=False):
    """
    Setter method for network_ref, mapped from YANG variable /networks/network/link/te/information_source_state/topology/network_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_ref() directly.

    YANG Description: Used to reference a network -- for example, an underlay
network.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)""",
        })

    self.__network_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_ref(self):
    self.__network_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)

  link_ref = __builtin__.property(_get_link_ref)
  network_ref = __builtin__.property(_get_network_ref)


  _pyangbind_elements = OrderedDict([('link_ref', link_ref), ('network_ref', network_ref), ])


