/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.postit.AreaLayoutFixedWidth;
import net.sourceforge.plantuml.postit.Elastic;
import net.sourceforge.plantuml.postit.PostIt;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Area
implements Elastic {
    private final String title;
    private final char id;
    private Dimension2D minimunDimension;
    private final List<PostIt> postIts = new ArrayList<PostIt>();

    public Area(char c, String string) {
        this.id = c;
        this.title = string;
    }

    public char getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Dimension2D getMinimunDimension() {
        return this.minimunDimension;
    }

    public void setMinimunDimension(Dimension2D dimension2D) {
        this.minimunDimension = dimension2D;
    }

    public Dimension2D getDimension() {
        throw new UnsupportedOperationException();
    }

    public double heightWhenWidthIs(double d, StringBounder stringBounder) {
        AreaLayoutFixedWidth areaLayoutFixedWidth = new AreaLayoutFixedWidth(d);
        Map<PostIt, Point2D> map = areaLayoutFixedWidth.getPositions(this.postIts, stringBounder);
        double d2 = 10.0;
        for (Map.Entry<PostIt, Point2D> entry : map.entrySet()) {
            double d3 = entry.getKey().getDimension(stringBounder).getHeight() + entry.getValue().getY();
            d2 = Math.max(d2, d3);
        }
        return d2 + 10.0;
    }

    public double widthWhenHeightIs(double d, StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    public void add(PostIt postIt) {
        this.postIts.add(postIt);
    }

    public void drawU(UGraphic uGraphic, double d) {
        AreaLayoutFixedWidth areaLayoutFixedWidth = new AreaLayoutFixedWidth(d);
        Map<PostIt, Point2D> map = areaLayoutFixedWidth.getPositions(this.postIts, uGraphic.getStringBounder());
        for (Map.Entry<PostIt, Point2D> entry : map.entrySet()) {
            UGraphic uGraphic2 = uGraphic.apply(new UTranslate(entry.getValue().getX(), entry.getValue().getY()));
            entry.getKey().drawU(uGraphic2);
        }
    }
}

