"""
P4 device example configuration.
"""

from copy import deepcopy
try:
    from .context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
except ImportError:
    from device.proto.context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
from .Tools import config_rule_set

DEVICE_P4_ID = 0
DEVICE_P4_NAME = 'device:leaf1'
DEVICE_P4_TYPE = 'p4-switch'
DEVICE_P4_ADDRESS = '127.0.0.1'
DEVICE_P4_PORT = '50101'
DEVICE_P4_DRIVERS = [DeviceDriverEnum.DEVICEDRIVER_P4]
DEVICE_P4_VENDOR = 'Open Networking Foundation'
DEVICE_P4_HW_VER = 'BMv2 simple_switch'
DEVICE_P4_SW_VER = 'Stratum'
DEVICE_P4_PIPECONF = 'org.onosproject.pipelines.fabric'
DEVICE_P4_WORKERS = 2
DEVICE_P4_GRACE_PERIOD = 60

DEVICE_P4_UUID = {'device_uuid': {'uuid': DEVICE_P4_NAME}}
DEVICE_P4 = {
    'device_id': deepcopy(DEVICE_P4_UUID),
    'device_type': DEVICE_P4_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_P4_DRIVERS,
    'device_endpoints': [],
}

DEVICE_P4_CONNECT_RULES = [
    config_rule_set('_connect/address', DEVICE_P4_ADDRESS),
    config_rule_set('_connect/port', DEVICE_P4_PORT),
    config_rule_set('_connect/settings', {
        'id': int(DEVICE_P4_ID),
        'name': DEVICE_P4_NAME,
        'hw-ver': DEVICE_P4_HW_VER,
        'sw-ver': DEVICE_P4_SW_VER,
        'pipeconf': DEVICE_P4_PIPECONF
    }),
]

DEVICE_P4_CONFIG_RULES = [
    config_rule_set('key1', 'value1'),
]
