import grpc, logging
from common.tools.client.RetryDecorator import retry, delay_exponential
from slice.proto.context_pb2 import Empty
from slice.proto.slice_pb2 import TransportSlice, SliceStatus
from slice.proto.slice_pb2_grpc import SliceServiceStub

LOGGER = logging.getLogger(__name__)
MAX_RETRIES = 15
DELAY_FUNCTION = delay_exponential(initial=0.01, increment=2.0, maximum=5.0)

class SliceClient:
    def __init__(self, address, port):
        self.endpoint = '{}:{}'.format(address, port)
        LOGGER.debug('Creating channel to {}...'.format(self.endpoint))
        self.channel = None
        self.stub = None
        self.connect()
        LOGGER.debug('Channel created')

    def connect(self):
        self.channel = grpc.insecure_channel(self.endpoint)
        self.stub = SliceServiceStub(self.channel)

    def close(self):
        if(self.channel is not None): self.channel.close()
        self.channel = None
        self.stub = None

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def CreateUpdateSlice(self, request : TransportSlice) -> SliceStatus:
        LOGGER.debug('CreateUpdateSlice request: {}'.format(request))
        response = self.stub.CreateUpdateSlice(request)
        LOGGER.debug('CreateUpdateSlice result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def DeleteSlice(self, request : TransportSlice) -> Empty:
        LOGGER.debug('DeleteSlice request: {}'.format(request))
        response = self.stub.DeleteSlice(request)
        LOGGER.debug('DeleteSlice result: {}'.format(response))
        return response
