# Infinera Readme

There are some instructions at https://gitlab.com/teraflow-h2020/controller/-/tree/develop/tutorial . They are not completely up to date and don't 100% work.

Note that many of the scripts expect this and that K8s namespace being used, they are not consistent, so use manual kubectl commands where necessary.

Infinera repo (cloned from upstream) is https://bitbucket.infinera.com/projects/XRCA/repos/teraflow/browse . The main development branch for us is xr-development (branched of origin/develop).

## Preliminaries

Kubernetes must be installed and configured.

Note that if runninc MicroK8s (I would highly recommend it), then install also regular kubectl so that scripts work. That is, download the kubectl, and also export credidentials to standard location.

```bash
# As a root
su -
cd /usr/local/bin
curl -LO "https://dl.k8s.io/release/$(curl -L -s https://dl.k8s.io/release/stable.txt)/bin/linux/amd64/kubectl"
chmod 755 kubectl
exit

# As your local user
cd ~/.kube
microk8s config > config
```

Local Docker registry is needed for build results. Use the following command to start local registry (docker will pull necessary images from Internet)

```bash
docker run -d -p 32000:5000 --restart=always --name registry registry:2
```

Setup mydeploy script outside the git repo. E.g. following will do. SOURCE IT ON ALL SHELLS.

IMPORTANT: September 2022 version of controller has a bug where any update to device trigger update to device
until GRPC endpoints are so loaded that K8s kills device service. XR does not need automation service, so it can
be left out.

```bash
export TFS_REGISTRY_IMAGE="http://localhost:32000/tfs/"
# Without automation service (see note above)
export TFS_COMPONENTS="context device pathcomp service slice compute monitoring webui"
# Correct setting
# export TFS_COMPONENTS="context device automation pathcomp service slice compute monitoring webui"
# Pre-rebase
#export TFS_COMPONENTS="context device automation service compute monitoring webui"
export TFS_IMAGE_TAG="dev"
export TFS_K8S_NAMESPACE="tfs"
export TFS_EXTRA_MANIFESTS="manifests/nginx_ingress_http.yaml"
export TFS_GRAFANA_PASSWORD="admin123+"
```

Build is containerized, pytest used for setup is not. Teraflow has some third party venv suggestion in docs. However standard venv works. Create:

```bash
python -m venv .venv
source .venv/bin/activate
./install_requirements.sh
```

SOURCE VENV ACTIVATE ON ANY SHELL USED FOR PYTHON RELATED WORK (e.g. pytest).

Use apt-get to install any missing tools (e.g. jq is required).

For host based Python development (e.g. VS Code) and test script execution, generate protobuf stubs:

```bash
cd proto
./generate_code_python.sh 
cd ../src/context
ln -s ../../proto/src/python proto
```

For VS Code python extension imports it is convenient to set file .env to top level with content:

```
PYTHONPATH=src
```
This will make imports to work properly in all cases.

## Building

Run deploy script to build in docker containers and then instantiate to configured K8s cluster. Deploy script must be sources for this to work!

```bash
./deploy.sh
```

If protobuf definitions have changed, regenerate version controlled Java files manually
(it is a horrifying bug in build system that this is not automated!).
```
cd automation
# In case Java is not already installed
sudo apt-get install openjdk-11-jdk -y
export MAVEN_OPTS='--add-exports=java.base/jdk.internal.module=ALL-UNNAMED --add-exports jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED   --add-exports jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED   --add-exports jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED   --add-exports jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED --add-exports jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED   --add-exports jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED'
cd src/policy
./mvnw compile
cd -
cd src/automation
./mvnw compile
```

Compilation fails but does update the protobuf generated files.

## Testing

Upload descriptors_emulatex_xr.json via WEB UI to setup fake topology.

Setup service by following commands in src directory. Kubernetes endpoins change on every build, so setup script is mandatory.

```bash
    source tests/ofc22/setup_test_env.sh 
    python -m pytest --verbose tests/ofc22/tests/test_functional_create_service_xr.py 
```

Good logs to check are:

* kubectl logs   service/deviceservice     --namespace tfs
* kubectl logs   service/webuiservice     --namespace tfs

## Unit Tests
Run in src directory (src under repo top level) with command:

```bash
PYTHONPATH=. pytest device/service/drivers/xr/cm
```

The PYTHONPATH is vital for imports to work properly.

## cm-cli

The tool cm-cli in the xr driver directory can be use to connect to CM and test the connectivity. For example:

```bash
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --show-constellation-by-hub-name="XR HUB 1"
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --list-constellations
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --create-connection="FOO;XR HUB 1|XR-T4;XR LEAF 1|XR-T1"
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --show-connection-by-name="FooBar123"
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --list-connections
# Modify argumens: href;uuid;ifname;ifname
# uuid translates to name TF:uuid
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --modify-connection="/network-connections/0637da3b-3b20-4b44-a513-035e6ef897a3;MyCon1;XR HUB 1|XR-T1;XR LEAF 1|XR-T2;25"
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --delete-connection=/network-connections/138f0cc0-3dc6-4195-97c0-2cbed5fd59ba
 ./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --create-transport-capacity="FOO;XR HUB 1|XR-T4;XR LEAF 1|XR-T1;12"
 ./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --list-transport-capacities
# Exercise almost full path of SetConfig. Can also be used for changing bandwidth (e.g. in demos) of an service
./cm-cli.py 172.19.219.44  443 xr-user-1 xr-user-1 --emulate-tf-set-config-service="XR HUB 1;teraflow_service_uuid;XR HUB 1|XR-T4;XR LEAF 1|XR-T1;125"
```
