# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class te_topology_identifier(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/te-topology-identifier. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: TE topology identifier container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__provider_id','__client_id','__topology_id',)

  _yang_name = 'te-topology-identifier'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__provider_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="provider-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)
    self.__client_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="client-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)
    self.__topology_id = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([a-zA-Z0-9\\-_.]+:)*/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}),], default=six.text_type(""), is_leaf=True, yang_name="topology-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-topology-id', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'te-topology-identifier']

  def _get_provider_id(self):
    """
    Getter method for provider_id, mapped from YANG variable /networks/network/te_topology_identifier/provider_id (te-global-id)

    YANG Description: An identifier to uniquely identify a provider.
If omitted, it assumes that the topology provider ID
value = 0 (the default).
    """
    return self.__provider_id
      
  def _set_provider_id(self, v, load=False):
    """
    Setter method for provider_id, mapped from YANG variable /networks/network/te_topology_identifier/provider_id (te-global-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_provider_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_provider_id() directly.

    YANG Description: An identifier to uniquely identify a provider.
If omitted, it assumes that the topology provider ID
value = 0 (the default).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="provider-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """provider_id must be of a type compatible with te-global-id""",
          'defined-type': "ietf-te-topology:te-global-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="provider-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)""",
        })

    self.__provider_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_provider_id(self):
    self.__provider_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="provider-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)


  def _get_client_id(self):
    """
    Getter method for client_id, mapped from YANG variable /networks/network/te_topology_identifier/client_id (te-global-id)

    YANG Description: An identifier to uniquely identify a client.
If omitted, it assumes that the topology client ID
value = 0 (the default).
    """
    return self.__client_id
      
  def _set_client_id(self, v, load=False):
    """
    Setter method for client_id, mapped from YANG variable /networks/network/te_topology_identifier/client_id (te-global-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_client_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_client_id() directly.

    YANG Description: An identifier to uniquely identify a client.
If omitted, it assumes that the topology client ID
value = 0 (the default).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="client-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """client_id must be of a type compatible with te-global-id""",
          'defined-type': "ietf-te-topology:te-global-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="client-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)""",
        })

    self.__client_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_client_id(self):
    self.__client_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="client-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-global-id', is_config=True)


  def _get_topology_id(self):
    """
    Getter method for topology_id, mapped from YANG variable /networks/network/te_topology_identifier/topology_id (te-topology-id)

    YANG Description: When the datastore contains several topologies,
'topology-id' distinguishes between them.  If omitted,
the default (empty) string for this leaf is assumed.
    """
    return self.__topology_id
      
  def _set_topology_id(self, v, load=False):
    """
    Setter method for topology_id, mapped from YANG variable /networks/network/te_topology_identifier/topology_id (te-topology-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_topology_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_topology_id() directly.

    YANG Description: When the datastore contains several topologies,
'topology-id' distinguishes between them.  If omitted,
the default (empty) string for this leaf is assumed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([a-zA-Z0-9\\-_.]+:)*/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}),], default=six.text_type(""), is_leaf=True, yang_name="topology-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-topology-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """topology_id must be of a type compatible with te-topology-id""",
          'defined-type': "ietf-te-topology:te-topology-id",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([a-zA-Z0-9\\-_.]+:)*/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}),], default=six.text_type(""), is_leaf=True, yang_name="topology-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-topology-id', is_config=True)""",
        })

    self.__topology_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_topology_id(self):
    self.__topology_id = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([a-zA-Z0-9\\-_.]+:)*/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}),], default=six.text_type(""), is_leaf=True, yang_name="topology-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-topology-id', is_config=True)

  provider_id = __builtin__.property(_get_provider_id, _set_provider_id)
  client_id = __builtin__.property(_get_client_id, _set_client_id)
  topology_id = __builtin__.property(_get_topology_id, _set_topology_id)


  _pyangbind_elements = OrderedDict([('provider_id', provider_id), ('client_id', client_id), ('topology_id', topology_id), ])


