# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class otn_link(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/te-link-attributes/otn-link. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Attributes of the OTN Link.
  """
  __slots__ = ('_path_helper', '_extmethods', '__odtu_flex_type','__tsg','__distance',)

  _yang_name = 'otn-link'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__odtu_flex_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)
    self.__tsg = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    self.__distance = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="distance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint32', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'te-link-attributes', 'otn-link']

  def _get_odtu_flex_type(self):
    """
    Getter method for odtu_flex_type, mapped from YANG variable /networks/network/link/te/te_link_attributes/otn_link/odtu_flex_type (l1-types:odtu-flex-type)

    YANG Description: The type of Optical Data Tributary Unit (ODTU)
whose nominal bitrate is used to compute the number of
Tributary Slots (TS) required by the ODUflex LSPs set up
on this OTN Link.
    """
    return self.__odtu_flex_type
      
  def _set_odtu_flex_type(self, v, load=False):
    """
    Setter method for odtu_flex_type, mapped from YANG variable /networks/network/link/te/te_link_attributes/otn_link/odtu_flex_type (l1-types:odtu-flex-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_odtu_flex_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_odtu_flex_type() directly.

    YANG Description: The type of Optical Data Tributary Unit (ODTU)
whose nominal bitrate is used to compute the number of
Tributary Slots (TS) required by the ODUflex LSPs set up
on this OTN Link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """odtu_flex_type must be of a type compatible with l1-types:odtu-flex-type""",
          'defined-type': "l1-types:odtu-flex-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)""",
        })

    self.__odtu_flex_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_odtu_flex_type(self):
    self.__odtu_flex_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)


  def _get_tsg(self):
    """
    Getter method for tsg, mapped from YANG variable /networks/network/link/te/te_link_attributes/otn_link/tsg (identityref)

    YANG Description: Tributary slot granularity.
    """
    return self.__tsg
      
  def _set_tsg(self, v, load=False):
    """
    Setter method for tsg, mapped from YANG variable /networks/network/link/te/te_link_attributes/otn_link/tsg (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tsg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tsg() directly.

    YANG Description: Tributary slot granularity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tsg must be of a type compatible with identityref""",
          'defined-type': "ietf-otn-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)""",
        })

    self.__tsg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tsg(self):
    self.__tsg = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)


  def _get_distance(self):
    """
    Getter method for distance, mapped from YANG variable /networks/network/link/te/te_link_attributes/otn_link/distance (uint32)

    YANG Description: distance in the unit of kilometers
    """
    return self.__distance
      
  def _set_distance(self, v, load=False):
    """
    Setter method for distance, mapped from YANG variable /networks/network/link/te/te_link_attributes/otn_link/distance (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_distance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_distance() directly.

    YANG Description: distance in the unit of kilometers
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="distance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """distance must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="distance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint32', is_config=True)""",
        })

    self.__distance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_distance(self):
    self.__distance = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="distance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint32', is_config=True)

  odtu_flex_type = __builtin__.property(_get_odtu_flex_type, _set_odtu_flex_type)
  tsg = __builtin__.property(_get_tsg, _set_tsg)
  distance = __builtin__.property(_get_distance, _set_distance)


  _pyangbind_elements = OrderedDict([('odtu_flex_type', odtu_flex_type), ('tsg', tsg), ('distance', distance), ])


