/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.model;

import eu.teraflow.policy.monitoring.model.KpiValue;

public class PolicyRuleCondition {

    private final String kpiId;
    private final NumericalOperator numericalOperator;
    private final KpiValue<?> kpiValue;

    public PolicyRuleCondition(String kpiId, NumericalOperator numericalOperator, KpiValue kpiValue) {
        this.kpiId = kpiId;
        this.numericalOperator = numericalOperator;
        this.kpiValue = kpiValue;
    }

    public String getKpiId() {
        return kpiId;
    }

    public NumericalOperator getNumericalOperator() {
        return numericalOperator;
    }

    public KpiValue getKpiValue() {
        return kpiValue;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{kpiId:\"%s\", numericalOperator:\"%s\", %s}",
                getClass().getSimpleName(), kpiId, numericalOperator.toString(), kpiValue);
    }
}
