#!/bin/bash
# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# OECC/PSC 22 deployment settings

export REGISTRY_IMAGE=""
export COMPONENTS="context device monitoring service slice interdomain compute" # webui
export IMAGE_TAG="oeccpsc22"
export K8S_HOSTNAME="kubernetes-master"
#export GRAFANA_PASSWORD="admin123+"

# Deploy TeraFlow instance 1
export K8S_NAMESPACE="oeccpsc22-1"
export EXTRA_MANIFESTS="./oeccpsc22/expose_services_teraflow_1.yaml"
./deploy_in_kubernetes.sh

# Deploy TeraFlow instance 2
export K8S_NAMESPACE="oeccpsc22-2"
export EXTRA_MANIFESTS="./oeccpsc22/expose_services_teraflow_2.yaml"
./deploy_in_kubernetes.sh
