# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc, logging
from common.rpc_method_wrapper.Decorator import create_metrics, safe_and_metered_rpc_method
from slice.proto.context_pb2 import Empty
from slice.proto.slice_pb2 import SliceStatus, TransportSlice
from slice.proto.slice_pb2_grpc import SliceServiceServicer

LOGGER = logging.getLogger(__name__)

SERVICE_NAME = 'Slice'
METHOD_NAMES = ['CreateUpdateSlice', 'DeleteSlice']
METRICS = create_metrics(SERVICE_NAME, METHOD_NAMES)

class SliceServiceServicerImpl(SliceServiceServicer):
    def __init__(self):
        LOGGER.debug('Creating Servicer...')
        LOGGER.debug('Servicer Created')

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def CreateUpdateSlice(self, request : TransportSlice, context : grpc.ServicerContext) -> SliceStatus:
        return SliceStatus()

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def DeleteSlice(self, request : TransportSlice, context : grpc.ServicerContext) -> Empty:
        return Empty()
