# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class nsrlg(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/te/nsrlg. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of NSRLGs (Non-Shared Risk Link Groups).
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__disjointness',)

  _yang_name = 'nsrlg'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__disjointness = YANGDynClass(base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-path-disjointness', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'te', 'nsrlg']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /networks/network/te/nsrlg/id (uint32)

    YANG Description: Identifies the NSRLG entry.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /networks/network/te/nsrlg/id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Identifies the NSRLG entry.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_disjointness(self):
    """
    Getter method for disjointness, mapped from YANG variable /networks/network/te/nsrlg/disjointness (te-types:te-path-disjointness)

    YANG Description: The type of resource disjointness.
    """
    return self.__disjointness
      
  def _set_disjointness(self, v, load=False):
    """
    Setter method for disjointness, mapped from YANG variable /networks/network/te/nsrlg/disjointness (te-types:te-path-disjointness)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_disjointness is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_disjointness() directly.

    YANG Description: The type of resource disjointness.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-path-disjointness', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """disjointness must be of a type compatible with te-types:te-path-disjointness""",
          'defined-type': "te-types:te-path-disjointness",
          'generated-type': """YANGDynClass(base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-path-disjointness', is_config=True)""",
        })

    self.__disjointness = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_disjointness(self):
    self.__disjointness = YANGDynClass(base=YANGBitsType(allowed_bits={'node': '0', 'link': '1', 'srlg': '2'}), is_leaf=True, yang_name="disjointness", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-path-disjointness', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  disjointness = __builtin__.property(_get_disjointness, _set_disjointness)


  _pyangbind_elements = OrderedDict([('id', id), ('disjointness', disjointness), ])


